/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.features.metadata;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.common.features.metadata.Aot;
import io.helidon.common.features.metadata.Deprecation;
import io.helidon.common.features.metadata.FeatureMetadataSupport;
import io.helidon.common.features.metadata.FeatureStatus;
import io.helidon.common.features.metadata.Flavor;
import io.helidon.metadata.hson.Hson;
import java.util.List;
import java.util.Optional;

@Prototype.Blueprint(decorator=FeatureMetadataSupport.class)
interface FeatureMetadataBlueprint {
    public String module();

    public String name();

    public Optional<String> description();

    public List<String> path();

    public Optional<String> since();

    @Option.Singular
    public List<Flavor> flavors();

    @Option.Singular
    public List<Flavor> invalidFlavors();

    public Optional<Aot> aot();

    public Optional<Deprecation> deprecation();

    public FeatureStatus status();

    default public Hson.Struct toHson() {
        return FeatureMetadataSupport.toHson(this);
    }

    default public String stringPath() {
        return String.join((CharSequence)"/", this.path());
    }
}

