/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.uptime;

import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.uptime.NodeUptimeData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.event.ConsensusEvent;
import org.hiero.consensus.model.node.NodeId;

public class UptimeData {
    public static final long NO_ROUND = -1L;
    private static final Logger logger = LogManager.getLogger(UptimeData.class);
    private final SortedMap<NodeId, NodeUptimeData> data = new TreeMap<NodeId, NodeUptimeData>();

    @Nullable
    public Instant getLastEventTime(@NonNull NodeId id) {
        Objects.requireNonNull(id, "id must not be null");
        NodeUptimeData nodeData = (NodeUptimeData)this.data.get(id);
        if (nodeData == null) {
            return null;
        }
        return nodeData.getLastEventTime();
    }

    public long getLastEventRound(@NonNull NodeId id) {
        Objects.requireNonNull(id, "id must not be null");
        NodeUptimeData nodeData = (NodeUptimeData)this.data.get(id);
        if (nodeData == null) {
            return -1L;
        }
        return nodeData.getLastEventRound();
    }

    @Nullable
    public Instant getLastJudgeTime(@NonNull NodeId id) {
        Objects.requireNonNull(id, "id must not be null");
        NodeUptimeData nodeData = (NodeUptimeData)this.data.get(id);
        if (nodeData == null) {
            return null;
        }
        return nodeData.getLastJudgeTime();
    }

    public long getLastJudgeRound(@NonNull NodeId id) {
        Objects.requireNonNull(id, "id must not be null");
        NodeUptimeData nodeData = (NodeUptimeData)this.data.get(id);
        if (nodeData == null) {
            return -1L;
        }
        return nodeData.getLastJudgeRound();
    }

    @NonNull
    public Set<NodeId> getTrackedNodes() {
        return new HashSet<NodeId>(this.data.keySet());
    }

    public void recordLastEvent(@NonNull ConsensusEvent event, long round) {
        NodeUptimeData nodeData = (NodeUptimeData)this.data.get(event.getCreatorId());
        if (nodeData == null) {
            logger.warn(LogMarker.EXCEPTION.getMarker(), "Node {} is not being tracked by the uptime tracker.", (Object)event.getCreatorId());
            return;
        }
        nodeData.setLastEventRound(round).setLastEventTime(event.getConsensusTimestamp());
    }

    public void recordLastJudge(@NonNull ConsensusEvent event, long round) {
        NodeUptimeData nodeData = (NodeUptimeData)this.data.get(event.getCreatorId());
        if (nodeData == null) {
            logger.warn(LogMarker.EXCEPTION.getMarker(), "Node {} is not being tracked by the uptime tracker.", (Object)event.getCreatorId());
            return;
        }
        nodeData.setLastJudgeRound(round).setLastJudgeTime(event.getConsensusTimestamp());
    }

    public void addNode(@NonNull NodeId node) {
        Objects.requireNonNull(node, "node must not be null");
        this.data.put(node, new NodeUptimeData());
    }

    public void removeNode(@NonNull NodeId node) {
        Objects.requireNonNull(node, "node must not be null");
        this.data.remove(node);
    }
}

