/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.wiring;

import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.component.framework.component.ComponentWiring;
import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerConfiguration;
import com.swirlds.platform.builder.PlatformComponentBuilder;
import com.swirlds.platform.components.AppNotifier;
import com.swirlds.platform.components.EventWindowManager;
import com.swirlds.platform.components.SavedStateController;
import com.swirlds.platform.components.appcomm.CompleteStateNotificationWithCleanup;
import com.swirlds.platform.components.appcomm.LatestCompleteStateNotifier;
import com.swirlds.platform.event.branching.BranchDetector;
import com.swirlds.platform.event.branching.BranchReporter;
import com.swirlds.platform.event.preconsensus.InlinePcesWriter;
import com.swirlds.platform.event.preconsensus.PcesReplayer;
import com.swirlds.platform.event.stream.ConsensusEventStream;
import com.swirlds.platform.event.validation.EventSignatureValidator;
import com.swirlds.platform.eventhandling.StateWithHashComplexity;
import com.swirlds.platform.eventhandling.TransactionHandler;
import com.swirlds.platform.eventhandling.TransactionHandlerDataCounter;
import com.swirlds.platform.eventhandling.TransactionHandlerResult;
import com.swirlds.platform.eventhandling.TransactionPrehandler;
import com.swirlds.platform.state.hasher.StateHasher;
import com.swirlds.platform.state.hashlogger.HashLogger;
import com.swirlds.platform.state.iss.IssDetector;
import com.swirlds.platform.state.iss.IssHandler;
import com.swirlds.platform.state.nexus.LatestCompleteStateNexus;
import com.swirlds.platform.state.nexus.SignedStateNexus;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.SignedStateSentinel;
import com.swirlds.platform.state.signed.StateGarbageCollector;
import com.swirlds.platform.state.signed.StateSignatureCollector;
import com.swirlds.platform.state.signer.StateSigner;
import com.swirlds.platform.state.snapshot.StateSnapshotManager;
import com.swirlds.platform.system.PlatformMonitor;
import com.swirlds.platform.wiring.PlatformSchedulersConfig;
import com.swirlds.platform.wiring.components.ConsensusWiring;
import com.swirlds.platform.wiring.components.GossipWiring;
import com.swirlds.platform.wiring.components.PcesReplayerWiring;
import com.swirlds.platform.wiring.components.RunningEventHashOverrideWiring;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.function.ToLongFunction;
import org.hiero.consensus.event.creator.EventCreatorModule;
import org.hiero.consensus.event.intake.EventIntakeModule;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.notification.IssNotification;
import org.hiero.consensus.model.state.StateSavingResult;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;
import org.hiero.consensus.orphan.OrphanBuffer;

public record PlatformComponents(WiringModel model, EventCreatorModule eventCreatorModule, EventIntakeModule eventIntakeModule, ComponentWiring<EventSignatureValidator, PlatformEvent> eventSignatureValidatorWiring, ComponentWiring<OrphanBuffer, List<PlatformEvent>> orphanBufferWiring, ConsensusWiring consensusEngineWiring, ComponentWiring<TransactionPrehandler, Queue<ScopedSystemTransaction<StateSignatureTransaction>>> applicationTransactionPrehandlerWiring, ComponentWiring<StateSignatureCollector, List<ReservedSignedState>> stateSignatureCollectorWiring, ComponentWiring<StateSnapshotManager, StateSavingResult> stateSnapshotManagerWiring, ComponentWiring<StateSigner, StateSignatureTransaction> stateSignerWiring, ComponentWiring<TransactionHandler, TransactionHandlerResult> transactionHandlerWiring, ComponentWiring<ConsensusEventStream, Void> consensusEventStreamWiring, RunningEventHashOverrideWiring runningEventHashOverrideWiring, ComponentWiring<StateHasher, ReservedSignedState> stateHasherWiring, GossipWiring gossipWiring, PcesReplayerWiring pcesReplayerWiring, ComponentWiring<EventWindowManager, EventWindow> eventWindowManagerWiring, ComponentWiring<IssDetector, List<IssNotification>> issDetectorWiring, ComponentWiring<IssHandler, Void> issHandlerWiring, ComponentWiring<HashLogger, Void> hashLoggerWiring, ComponentWiring<LatestCompleteStateNotifier, CompleteStateNotificationWithCleanup> latestCompleteStateNotifierWiring, ComponentWiring<SignedStateNexus, Void> latestImmutableStateNexusWiring, ComponentWiring<LatestCompleteStateNexus, Void> latestCompleteStateNexusWiring, ComponentWiring<SavedStateController, StateWithHashComplexity> savedStateControllerWiring, ComponentWiring<AppNotifier, Void> notifierWiring, ComponentWiring<StateGarbageCollector, Void> stateGarbageCollectorWiring, ComponentWiring<SignedStateSentinel, Void> signedStateSentinelWiring, ComponentWiring<PlatformMonitor, PlatformStatus> platformMonitorWiring, ComponentWiring<BranchDetector, PlatformEvent> branchDetectorWiring, ComponentWiring<InlinePcesWriter, PlatformEvent> pcesInlineWriterWiring, ComponentWiring<BranchReporter, Void> branchReporterWiring) {
    public void bind(@NonNull PlatformComponentBuilder builder, @NonNull PcesReplayer pcesReplayer, @NonNull StateSignatureCollector stateSignatureCollector, @NonNull EventWindowManager eventWindowManager, @Nullable InlinePcesWriter inlinePcesWriter, @NonNull SignedStateNexus latestImmutableStateNexus, @NonNull LatestCompleteStateNexus latestCompleteStateNexus, @NonNull SavedStateController savedStateController, @NonNull AppNotifier notifier) {
        this.eventSignatureValidatorWiring.bind(builder::buildEventSignatureValidator);
        this.orphanBufferWiring.bind(builder::buildOrphanBuffer);
        this.consensusEngineWiring.bind(builder::buildConsensusEngine);
        this.stateSnapshotManagerWiring.bind(builder::buildStateSnapshotManager);
        this.stateSignerWiring.bind(builder::buildStateSigner);
        this.pcesReplayerWiring.bind(pcesReplayer);
        if (inlinePcesWriter != null) {
            this.pcesInlineWriterWiring.bind((Object)inlinePcesWriter);
        } else {
            this.pcesInlineWriterWiring.bind(builder::buildInlinePcesWriter);
        }
        this.stateSignatureCollectorWiring.bind((Object)stateSignatureCollector);
        this.eventWindowManagerWiring.bind((Object)eventWindowManager);
        this.applicationTransactionPrehandlerWiring.bind(builder::buildTransactionPrehandler);
        this.transactionHandlerWiring.bind(builder::buildTransactionHandler);
        this.consensusEventStreamWiring.bind(builder::buildConsensusEventStream);
        this.issDetectorWiring.bind(builder::buildIssDetector);
        this.issHandlerWiring.bind(builder::buildIssHandler);
        this.hashLoggerWiring.bind(builder::buildHashLogger);
        this.latestCompleteStateNotifierWiring.bind(builder::buildLatestCompleteStateNotifier);
        this.latestImmutableStateNexusWiring.bind((Object)latestImmutableStateNexus);
        this.latestCompleteStateNexusWiring.bind((Object)latestCompleteStateNexus);
        this.savedStateControllerWiring.bind((Object)savedStateController);
        this.stateHasherWiring.bind(builder::buildStateHasher);
        this.notifierWiring.bind((Object)notifier);
        this.stateGarbageCollectorWiring.bind(builder::buildStateGarbageCollector);
        this.platformMonitorWiring.bind(builder::buildPlatformMonitor);
        this.signedStateSentinelWiring.bind(builder::buildSignedStateSentinel);
        this.gossipWiring.bind(builder.buildGossip());
        this.branchDetectorWiring.bind(builder::buildBranchDetector);
        this.branchReporterWiring.bind(builder::buildBranchReporter);
    }

    public static PlatformComponents create(@NonNull PlatformContext platformContext, @NonNull WiringModel model, @NonNull EventCreatorModule eventCreatorModule, @NonNull EventIntakeModule eventIntakeModule) {
        Objects.requireNonNull(platformContext);
        Objects.requireNonNull(model);
        PlatformSchedulersConfig config = (PlatformSchedulersConfig)platformContext.getConfiguration().getConfigData(PlatformSchedulersConfig.class);
        return new PlatformComponents(model, eventCreatorModule, eventIntakeModule, (ComponentWiring<EventSignatureValidator, PlatformEvent>)new ComponentWiring(model, EventSignatureValidator.class, config.eventSignatureValidator()), (ComponentWiring<OrphanBuffer, List<PlatformEvent>>)new ComponentWiring(model, OrphanBuffer.class, config.orphanBuffer()), ConsensusWiring.create(model, config.consensusEngine()), (ComponentWiring<TransactionPrehandler, Queue<ScopedSystemTransaction<StateSignatureTransaction>>>)new ComponentWiring(model, TransactionPrehandler.class, config.applicationTransactionPrehandler()), (ComponentWiring<StateSignatureCollector, List<ReservedSignedState>>)new ComponentWiring(model, StateSignatureCollector.class, config.stateSignatureCollector()), (ComponentWiring<StateSnapshotManager, StateSavingResult>)new ComponentWiring(model, StateSnapshotManager.class, config.stateSnapshotManager()), (ComponentWiring<StateSigner, StateSignatureTransaction>)new ComponentWiring(model, StateSigner.class, config.stateSigner()), (ComponentWiring<TransactionHandler, TransactionHandlerResult>)new ComponentWiring(model, TransactionHandler.class, config.transactionHandler(), (ToLongFunction)TransactionHandlerDataCounter.create(config.transactionHandler())), (ComponentWiring<ConsensusEventStream, Void>)new ComponentWiring(model, ConsensusEventStream.class, config.consensusEventStream()), RunningEventHashOverrideWiring.create(model), (ComponentWiring<StateHasher, ReservedSignedState>)new ComponentWiring(model, StateHasher.class, config.stateHasher(), data -> {
            long l;
            if (data instanceof StateWithHashComplexity) {
                StateWithHashComplexity swhc = (StateWithHashComplexity)data;
                l = swhc.hashComplexity();
            } else {
                l = 1L;
            }
            return l;
        }), new GossipWiring(platformContext, model), PcesReplayerWiring.create(model), (ComponentWiring<EventWindowManager, EventWindow>)new ComponentWiring(model, EventWindowManager.class, TaskSchedulerConfiguration.DIRECT_THREADSAFE_CONFIGURATION), (ComponentWiring<IssDetector, List<IssNotification>>)new ComponentWiring(model, IssDetector.class, config.issDetector()), (ComponentWiring<IssHandler, Void>)new ComponentWiring(model, IssHandler.class, config.issHandler()), (ComponentWiring<HashLogger, Void>)new ComponentWiring(model, HashLogger.class, config.hashLogger()), (ComponentWiring<LatestCompleteStateNotifier, CompleteStateNotificationWithCleanup>)new ComponentWiring(model, LatestCompleteStateNotifier.class, config.latestCompleteStateNotifier()), (ComponentWiring<SignedStateNexus, Void>)new ComponentWiring(model, SignedStateNexus.class, TaskSchedulerConfiguration.DIRECT_THREADSAFE_CONFIGURATION), (ComponentWiring<LatestCompleteStateNexus, Void>)new ComponentWiring(model, LatestCompleteStateNexus.class, TaskSchedulerConfiguration.DIRECT_THREADSAFE_CONFIGURATION), (ComponentWiring<SavedStateController, StateWithHashComplexity>)new ComponentWiring(model, SavedStateController.class, TaskSchedulerConfiguration.DIRECT_THREADSAFE_CONFIGURATION), (ComponentWiring<AppNotifier, Void>)new ComponentWiring(model, AppNotifier.class, TaskSchedulerConfiguration.DIRECT_THREADSAFE_CONFIGURATION), (ComponentWiring<StateGarbageCollector, Void>)new ComponentWiring(model, StateGarbageCollector.class, config.stateGarbageCollector()), (ComponentWiring<SignedStateSentinel, Void>)new ComponentWiring(model, SignedStateSentinel.class, config.signedStateSentinel()), (ComponentWiring<PlatformMonitor, PlatformStatus>)new ComponentWiring(model, PlatformMonitor.class, config.platformMonitor()), (ComponentWiring<BranchDetector, PlatformEvent>)new ComponentWiring(model, BranchDetector.class, config.branchDetector()), (ComponentWiring<InlinePcesWriter, PlatformEvent>)new ComponentWiring(model, InlinePcesWriter.class, config.pcesInlineWriter()), (ComponentWiring<BranchReporter, Void>)new ComponentWiring(model, BranchReporter.class, config.branchReporter()));
    }
}

