/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common;

import io.helidon.common.GenericTypeUtil;
import java.lang.reflect.Type;
import java.util.Objects;

public class GenericType<T>
implements Type {
    public static final GenericType<String> STRING = GenericType.create(String.class);
    public static final GenericType<Object> OBJECT = GenericType.create(Object.class);
    private final Type type;
    private final Class<?> rawType;

    public static <N> GenericType<N> create(Type genericType) throws IllegalArgumentException {
        Objects.requireNonNull(genericType);
        return new GenericType(genericType, GenericTypeUtil.rawClass(genericType));
    }

    public static <N> GenericType<N> create(Class<N> clazz) {
        return new GenericType(clazz, clazz);
    }

    public static <N> GenericType<N> create(N object) {
        return GenericType.create(object.getClass());
    }

    private GenericType(Type type, Class<?> rawType) {
        this.type = type;
        this.rawType = rawType;
    }

    protected GenericType() throws IllegalArgumentException {
        this.type = GenericTypeUtil.typeArgument(this.getClass(), GenericType.class);
        this.rawType = GenericTypeUtil.rawClass(this.type);
    }

    public Type type() {
        return this.type;
    }

    public Class<?> rawType() {
        return this.rawType;
    }

    public boolean isClass() {
        return this.rawType.equals(this.type);
    }

    public T cast(Object object) throws ClassCastException {
        return (T)object;
    }

    @Override
    public String getTypeName() {
        return this.type().toString();
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GenericType) {
            return ((GenericType)obj).type.equals(this.type);
        }
        return false;
    }

    public String toString() {
        return this.type.toString();
    }
}

