/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http1;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.Headers;
import io.helidon.http.HttpPrologue;
import io.helidon.http.Status;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.http1.Http1ConnectionListener;

public class Http1LoggingConnectionListener
implements Http1ConnectionListener {
    private final String prefix;
    private final System.Logger logger;

    public Http1LoggingConnectionListener(String prefix) {
        this.prefix = prefix;
        this.logger = System.getLogger(Http1LoggingConnectionListener.class.getName() + "." + prefix);
    }

    public void data(ConnectionContext ctx, BufferData data) {
        if (this.logger.isLoggable(System.Logger.Level.TRACE)) {
            ctx.log(this.logger, System.Logger.Level.TRACE, "%s data:%n%s", new Object[]{this.prefix, data.debugDataHex(true)});
        }
    }

    public void data(ConnectionContext ctx, byte[] bytes, int offset, int length) {
        if (this.logger.isLoggable(System.Logger.Level.TRACE)) {
            this.data(ctx, BufferData.create((byte[])bytes, (int)offset, (int)length));
        }
    }

    @Override
    public void prologue(ConnectionContext ctx, HttpPrologue prologue) {
        ctx.log(this.logger, System.Logger.Level.DEBUG, "%s prologue: %s", new Object[]{this.prefix, prologue});
    }

    @Override
    public void headers(ConnectionContext ctx, Headers headers) {
        ctx.log(this.logger, System.Logger.Level.DEBUG, "%s headers: %n%s", new Object[]{this.prefix, headers});
    }

    @Override
    public void status(ConnectionContext ctx, Status status) {
        ctx.log(this.logger, System.Logger.Level.DEBUG, "%s status: %s", new Object[]{this.prefix, status});
    }
}

