/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.metrics.platform;

import com.swirlds.base.utility.ToStringBuilder;
import com.swirlds.metrics.api.Metric;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.snapshot.Snapshot;
import com.swirlds.metrics.impl.AbstractMetric;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.IntSupplier;
import org.hiero.base.concurrent.atomic.AtomicIntPair;
import org.hiero.consensus.metrics.IntegerPairAccumulator;

public class PlatformIntegerPairAccumulator<T>
extends AbstractMetric
implements IntegerPairAccumulator<T> {
    private final Metric.DataType dataType;
    private final AtomicIntPair container;
    private final BiFunction<Integer, Integer, T> resultFunction;
    private final IntSupplier leftInitializer;
    private final IntSupplier rightInitializer;

    public PlatformIntegerPairAccumulator(@NonNull IntegerPairAccumulator.Config<T> config) {
        super(config);
        this.dataType = MetricConfig.mapDataType(config.getType());
        this.container = new AtomicIntPair(config.getLeftAccumulator(), config.getRightAccumulator());
        this.resultFunction = config.getResultFunction();
        this.leftInitializer = config.getLeftInitializer();
        this.rightInitializer = config.getRightInitializer();
        this.container.set(this.leftInitializer.getAsInt(), this.rightInitializer.getAsInt());
    }

    @NonNull
    public Metric.DataType getDataType() {
        return this.dataType;
    }

    @NonNull
    public List<Snapshot.SnapshotEntry> takeSnapshot() {
        Object result = this.container.computeAndSet(this.resultFunction, this.leftInitializer.getAsInt(), this.rightInitializer.getAsInt());
        return List.of(new Snapshot.SnapshotEntry(Metric.ValueType.VALUE, result));
    }

    @Override
    @NonNull
    public T get() {
        return (T)this.container.compute(this.resultFunction);
    }

    public void reset() {
        this.container.set(this.leftInitializer.getAsInt(), this.rightInitializer.getAsInt());
    }

    @Override
    public int getLeft() {
        return this.container.getLeft();
    }

    @Override
    public int getRight() {
        return this.container.getRight();
    }

    @Override
    public void update(int leftValue, int rightValue) {
        this.container.accumulate(leftValue, rightValue);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("value", this.get()).toString();
    }
}

