/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.datatypes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.datatypes.Address;

public record AccessListEntry(Address address, List<Bytes32> storageKeys) {
    @JsonCreator
    public static AccessListEntry createAccessListEntry(@JsonProperty(value="address") Address address, @JsonProperty(value="storageKeys") List<String> storageKeys) {
        return new AccessListEntry(address, storageKeys.stream().map(Bytes32::fromHexString).collect(Collectors.toList()));
    }

    @JsonProperty(value="address")
    public String getAddressString() {
        return this.address.toHexString();
    }

    @JsonProperty(value="storageKeys")
    public List<String> getStorageKeysString() {
        return this.storageKeys.stream().map(Bytes::toHexString).collect(Collectors.toList());
    }
}

