/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.preconsensus;

import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.pces.PcesConfig;
import org.hiero.consensus.pces.PcesFile;
import org.hiero.consensus.pces.PcesUtilities;

public final class BestEffortPcesFileCopy {
    private static final Logger logger = LogManager.getLogger(BestEffortPcesFileCopy.class);
    private static final int COPY_PCES_MAX_RETRIES = 10;

    private BestEffortPcesFileCopy() {
    }

    public static void copyPcesFilesRetryOnFailure(@NonNull Configuration configuration, @NonNull NodeId selfId, @NonNull Path destinationDirectory, long lowerBound, long round) {
        boolean copyPreconsensusStream = ((PcesConfig)configuration.getConfigData(PcesConfig.class)).copyRecentStreamToStateSnapshots();
        if (!copyPreconsensusStream) {
            return;
        }
        Path pcesDestination = destinationDirectory.resolve("preconsensus-events").resolve(Long.toString(selfId.id()));
        int triesRemaining = 10;
        while (triesRemaining > 0) {
            --triesRemaining;
            try {
                FileUtils.executeAndRename((Path)pcesDestination, temporaryDirectory -> BestEffortPcesFileCopy.copyPcesFiles(configuration, selfId, temporaryDirectory, lowerBound), (Configuration)configuration);
                return;
            }
            catch (IOException | UncheckedIOException e) {
                if (triesRemaining > 0) {
                    logger.warn(LogMarker.STATE_TO_DISK.getMarker(), "Unable to copy PCES files. Retrying.");
                    continue;
                }
                logger.error(LogMarker.EXCEPTION.getMarker(), "Unable to copy the last PCES file after {} retries. PCES files will not be written into the state snapshot for round {}.", (Object)10, (Object)round, (Object)e);
            }
        }
    }

    private static void copyPcesFiles(@NonNull Configuration configuration, @NonNull NodeId selfId, @NonNull Path destinationDirectory, long lowerBound) throws IOException {
        List<PcesFile> allFiles = BestEffortPcesFileCopy.gatherPcesFilesOnDisk(selfId, configuration);
        if (allFiles.isEmpty()) {
            return;
        }
        Collections.sort(allFiles);
        List<PcesFile> filesToCopy = BestEffortPcesFileCopy.getRequiredPcesFiles(allFiles, lowerBound);
        if (filesToCopy.isEmpty()) {
            return;
        }
        BestEffortPcesFileCopy.copyPcesFileList(filesToCopy, destinationDirectory);
    }

    @NonNull
    private static List<PcesFile> getRequiredPcesFiles(@NonNull List<PcesFile> allFiles, long lowerBound) {
        ArrayList<PcesFile> filesToCopy = new ArrayList<PcesFile>();
        PcesFile lastFile = allFiles.get(allFiles.size() - 1);
        for (PcesFile file : allFiles) {
            if (file.getOrigin() != lastFile.getOrigin() || file.getUpperBound() < lowerBound) continue;
            filesToCopy.add(file);
        }
        if (filesToCopy.isEmpty()) {
            logger.warn(LogMarker.STATE_TO_DISK.getMarker(), "No preconsensus event files meeting specified criteria found to copy. Lower bound: {}", (Object)lowerBound);
        } else if (filesToCopy.size() == 1) {
            logger.info(LogMarker.STATE_TO_DISK.getMarker(), "Found 1 preconsensus event file meeting specified criteria to copy.\n    Lower bound: {}\n    File: {}\n", (Object)lowerBound, (Object)((PcesFile)filesToCopy.get(0)).getPath());
        } else {
            logger.info(LogMarker.STATE_TO_DISK.getMarker(), "Found {} preconsensus event files meeting specified criteria to copy.\n    Lower bound: {}\n    First file to copy: {}\n    Last file to copy: {}\n", (Object)filesToCopy.size(), (Object)lowerBound, (Object)((PcesFile)filesToCopy.get(0)).getPath(), (Object)((PcesFile)filesToCopy.get(filesToCopy.size() - 1)).getPath());
        }
        return filesToCopy;
    }

    @NonNull
    private static List<PcesFile> gatherPcesFilesOnDisk(@NonNull NodeId selfId, @NonNull Configuration configuration) throws IOException {
        ArrayList<PcesFile> allFiles = new ArrayList<PcesFile>();
        Path preconsensusEventStreamDirectory = PcesUtilities.getDatabaseDirectory((Configuration)configuration, (NodeId)selfId);
        try (Stream<Path> stream = Files.walk(preconsensusEventStreamDirectory, new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                try {
                    allFiles.add(PcesFile.of((Path)path));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
        if (allFiles.isEmpty()) {
            logger.warn(LogMarker.STATE_TO_DISK.getMarker(), "No preconsensus event files found to copy");
        } else if (allFiles.size() == 1) {
            logger.info(LogMarker.STATE_TO_DISK.getMarker(), "Found 1 preconsensus file on disk.\n    File: {}", (Object)((PcesFile)allFiles.get(0)).getPath());
        } else {
            logger.info(LogMarker.STATE_TO_DISK.getMarker(), "Found {} preconsensus files on disk.\n    First file: {}\n    Last file: {}", (Object)allFiles.size(), (Object)((PcesFile)allFiles.get(0)).getPath(), (Object)((PcesFile)allFiles.get(allFiles.size() - 1)).getPath());
        }
        return allFiles;
    }

    private static void copyPcesFileList(@NonNull List<PcesFile> filesToCopy, @NonNull Path pcesDestination) throws IOException {
        logger.info(LogMarker.STATE_TO_DISK.getMarker(), "Copying {} preconsensus event file(s)", (Object)filesToCopy.size());
        for (int index = filesToCopy.size() - 1; index >= 0; --index) {
            PcesFile file = filesToCopy.get(index);
            Files.copy(file.getPath(), pcesDestination.resolve(file.getFileName()), new CopyOption[0]);
        }
        logger.info(LogMarker.STATE_TO_DISK.getMarker(), "Finished copying {} preconsensus event file(s)", (Object)filesToCopy.size());
    }
}

