/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage.contract;

import com.hedera.node.app.hapi.fees.usage.QueryUsage;
import com.hedera.node.app.hapi.fees.usage.contract.entities.ContractEntitySizes;
import com.hedera.node.app.hapi.fees.usage.crypto.entities.CryptoEntitySizes;
import com.hedera.node.app.hapi.utils.fee.FeeBuilder;
import com.hederahashgraph.api.proto.java.Key;
import com.hederahashgraph.api.proto.java.Query;
import java.nio.charset.StandardCharsets;

public final class ContractGetInfoUsage
extends QueryUsage {
    private ContractGetInfoUsage(Query query) {
        super(query.getContractGetInfo().getHeader().getResponseType());
        this.addTb(24L);
        this.addRb(ContractEntitySizes.CONTRACT_ENTITY_SIZES.fixedBytesInContractRepr());
    }

    public static ContractGetInfoUsage newEstimate(Query query) {
        return new ContractGetInfoUsage(query);
    }

    public ContractGetInfoUsage givenCurrentKey(Key key) {
        this.addRb(FeeBuilder.getAccountKeyStorageSize((Key)key));
        return this;
    }

    public ContractGetInfoUsage givenCurrentMemo(String memo) {
        this.addRb(memo.getBytes(StandardCharsets.UTF_8).length);
        return this;
    }

    public ContractGetInfoUsage givenCurrentTokenAssocs(int count) {
        this.addRb((long)count * CryptoEntitySizes.CRYPTO_ENTITY_SIZES.bytesInTokenAssocRepr());
        return this;
    }
}

