/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.cli;

import com.swirlds.base.time.Time;
import com.swirlds.cli.commands.StateCommand;
import com.swirlds.cli.utility.AbstractCommand;
import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.filesystem.FileSystemManager;
import com.swirlds.common.io.utility.RecycleBin;
import com.swirlds.common.io.utility.SimpleRecycleBin;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.state.SavedStateUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Scanner;
import org.hiero.consensus.metrics.noop.NoOpMetrics;
import picocli.CommandLine;

@CommandLine.Command(name="transplant", mixinStandardHelpOptions=true, description={"Prepare a state for transplanting to another network"})
@SubcommandOf(value=StateCommand.class)
public class PrepareForTransplantCommand
extends AbstractCommand {
    private static final int RETURN_CODE_SUCCESS = 0;
    private static final int RETURN_CODE_PROMPT_NO = 1;
    private Path statePath;
    @CommandLine.Option(names={"-ac", "--auto-confirm"}, description={"Automatically confirm the operation without prompting"})
    private boolean autoConfirm;

    @CommandLine.Parameters(description={"The path to the state to prepare for transplant"})
    private void setStatePath(Path statePath) {
        this.statePath = this.pathMustExist(statePath.toAbsolutePath());
    }

    public Integer call() throws IOException {
        if (!this.autoConfirm) {
            String response;
            System.out.println("Warning: This will overwrite the contents of the state directory, this is not reversible.");
            System.out.println("Do you want to continue? (Y/N): ");
            try (Scanner reader = new Scanner(System.in);){
                response = reader.nextLine();
            }
            if (!response.toUpperCase().startsWith("Y")) {
                System.out.println("Operation aborted.");
            }
            return 1;
        }
        Configuration configuration = ConfigurationBuilder.create().autoDiscoverExtensions().build();
        PlatformContext platformContext = PlatformContext.create((Configuration)configuration, (Time)Time.getCurrent(), (Metrics)new NoOpMetrics(), (FileSystemManager)FileSystemManager.create((Configuration)configuration), (RecycleBin)new SimpleRecycleBin());
        System.out.println("Transplanting state from: " + String.valueOf(this.statePath));
        int discardedEventCount = SavedStateUtils.prepareStateForTransplant(this.statePath, platformContext);
        System.out.printf("Transplant complete. %d events were discarded due to being from a future round.%n", discardedEventCount);
        return 0;
    }
}

