/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.base.utility;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ToStringBuilder {
    private static final Pattern SUPER_STRING_PATTERN = Pattern.compile("\\[(.*?)\\]");
    private static final String PACKAGE_PREFIX_PATTERN = "^.*\\.";
    private static final String NULL_STRING = "<null>";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char INNER_CLASS_SEPARATOR = '$';
    private final StringBuilder builder = new StringBuilder();
    private boolean parameterAdded = false;

    public ToStringBuilder(@NonNull Object object) {
        this.builder.append(ToStringBuilder.formatClassName(object.getClass().getName())).append("[");
    }

    @NonNull
    public ToStringBuilder appendSuper(@NonNull String superString) {
        Objects.requireNonNull(superString, "superString must not be null");
        Matcher matcher = SUPER_STRING_PATTERN.matcher(superString);
        if (matcher.find()) {
            this.builder.append(matcher.group(1));
            this.appendSeparator();
        }
        return this;
    }

    @NonNull
    public ToStringBuilder append(@Nullable Object value) {
        String formattedValue = value == null ? NULL_STRING : value.toString();
        this.builder.append(formattedValue);
        this.appendSeparator();
        return this;
    }

    @NonNull
    public ToStringBuilder append(@NonNull String fieldName, @Nullable Object value) {
        Objects.requireNonNull(fieldName, "fieldName must not be null");
        String formattedValue = value == null ? NULL_STRING : value.toString();
        this.builder.append(fieldName).append("=").append(formattedValue);
        this.appendSeparator();
        return this;
    }

    @NonNull
    public String toString() {
        if (this.parameterAdded) {
            this.builder.setLength(this.builder.length() - 1);
        }
        this.builder.append("]");
        return this.builder.toString();
    }

    @NonNull
    private static String formatClassName(@NonNull String input) {
        Objects.requireNonNull(input, "input must not be null");
        String withoutPackage = input.replaceFirst(PACKAGE_PREFIX_PATTERN, "");
        return withoutPackage.replace('$', '.');
    }

    private void appendSeparator() {
        this.builder.append(",");
        this.parameterAdded = true;
    }
}

