/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io.utility;

import com.swirlds.base.state.Startable;
import com.swirlds.base.state.Stoppable;
import com.swirlds.base.time.Time;
import com.swirlds.common.io.config.FileSystemManagerConfig;
import com.swirlds.common.io.filesystem.FileSystemManager;
import com.swirlds.common.io.utility.RecycleBinImpl;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Path;
import org.hiero.consensus.concurrent.manager.ThreadManager;
import org.hiero.consensus.model.node.NodeId;

public interface RecycleBin
extends Startable,
Stoppable {
    public void recycle(@NonNull Path var1) throws IOException;

    public static RecycleBin create(@NonNull Metrics metrics, @NonNull Configuration configuration, @NonNull ThreadManager threadManager, @NonNull Time time, @NonNull FileSystemManager fileSystemManager, @NonNull NodeId nodeId) {
        FileSystemManagerConfig fsmConfig = (FileSystemManagerConfig)configuration.getConfigData(FileSystemManagerConfig.class);
        Path recycleBinPath = fileSystemManager.resolve(Path.of(fsmConfig.recycleBinDir(), new String[0])).resolve(nodeId.toString());
        return new RecycleBinImpl(metrics, threadManager, time, recycleBinPath, fsmConfig.recycleBinMaximumFileAge(), fsmConfig.recycleBinCollectionPeriod());
    }
}

