/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.services;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.spi.migrate.HederaMigrationContext;
import com.hedera.node.app.spi.migrate.StartupNetworks;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.merkle.VirtualMapState;
import com.swirlds.state.spi.FilteredWritableStates;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;

public final class MigrationContextImpl
extends Record
implements HederaMigrationContext {
    @NonNull
    private final ReadableStates previousStates;
    @NonNull
    private final WritableStates newStates;
    @NonNull
    private final Configuration appConfig;
    @NonNull
    private final Configuration platformConfig;
    @Nullable
    private final SemanticVersion previousVersion;
    private final long roundNumber;
    @NonNull
    private final Map<String, Object> sharedValues;
    @NonNull
    private final StartupNetworks startupNetworks;

    public MigrationContextImpl(@NonNull ReadableStates previousStates, @NonNull WritableStates newStates, @NonNull Configuration appConfig, @NonNull Configuration platformConfig, @Nullable SemanticVersion previousVersion, long roundNumber, @NonNull Map<String, Object> sharedValues, @NonNull StartupNetworks startupNetworks) {
        Objects.requireNonNull(previousStates);
        Objects.requireNonNull(newStates);
        Objects.requireNonNull(appConfig);
        Objects.requireNonNull(platformConfig);
        this.previousStates = previousStates;
        this.newStates = newStates;
        this.appConfig = appConfig;
        this.platformConfig = platformConfig;
        this.previousVersion = previousVersion;
        this.roundNumber = roundNumber;
        this.sharedValues = sharedValues;
        this.startupNetworks = startupNetworks;
    }

    public void copyAndReleaseOnDiskState(int stateId) {
        WritableStates writableStates = this.newStates;
        if (writableStates instanceof VirtualMapState.MerkleWritableStates) {
            VirtualMapState.MerkleWritableStates merkleWritableStates = (VirtualMapState.MerkleWritableStates)writableStates;
            merkleWritableStates.copyAndReleaseVirtualMap(stateId);
        } else {
            FilteredWritableStates filteredWritableStates;
            writableStates = this.newStates;
            if (writableStates instanceof FilteredWritableStates && (writableStates = (filteredWritableStates = (FilteredWritableStates)writableStates).getDelegate()) instanceof VirtualMapState.MerkleWritableStates) {
                VirtualMapState.MerkleWritableStates merkleWritableStates = (VirtualMapState.MerkleWritableStates)writableStates;
                merkleWritableStates.copyAndReleaseVirtualMap(stateId);
            } else {
                throw new UnsupportedOperationException("On-disk state is inaccessible");
            }
        }
    }

    public Comparator<SemanticVersion> getVersionComparator() {
        return HapiUtils.SEMANTIC_VERSION_COMPARATOR;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{MigrationContextImpl.class, "previousStates;newStates;appConfig;platformConfig;previousVersion;roundNumber;sharedValues;startupNetworks", "previousStates", "newStates", "appConfig", "platformConfig", "previousVersion", "roundNumber", "sharedValues", "startupNetworks"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MigrationContextImpl.class, "previousStates;newStates;appConfig;platformConfig;previousVersion;roundNumber;sharedValues;startupNetworks", "previousStates", "newStates", "appConfig", "platformConfig", "previousVersion", "roundNumber", "sharedValues", "startupNetworks"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MigrationContextImpl.class, "previousStates;newStates;appConfig;platformConfig;previousVersion;roundNumber;sharedValues;startupNetworks", "previousStates", "newStates", "appConfig", "platformConfig", "previousVersion", "roundNumber", "sharedValues", "startupNetworks"}, this, o);
    }

    @NonNull
    public ReadableStates previousStates() {
        return this.previousStates;
    }

    @NonNull
    public WritableStates newStates() {
        return this.newStates;
    }

    @NonNull
    public Configuration appConfig() {
        return this.appConfig;
    }

    @NonNull
    public Configuration platformConfig() {
        return this.platformConfig;
    }

    @Nullable
    public SemanticVersion previousVersion() {
        return this.previousVersion;
    }

    public long roundNumber() {
        return this.roundNumber;
    }

    @NonNull
    public Map<String, Object> sharedValues() {
        return this.sharedValues;
    }

    @NonNull
    public StartupNetworks startupNetworks() {
        return this.startupNetworks;
    }
}

