/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.hasher;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.platform.eventhandling.StateWithHashComplexity;
import com.swirlds.platform.state.hasher.StateHasher;
import com.swirlds.platform.state.hasher.StateHasherMetrics;
import com.swirlds.platform.state.signed.ReservedSignedState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.time.Instant;

public class DefaultStateHasher
implements StateHasher {
    private final StateHasherMetrics metrics;

    public DefaultStateHasher(@NonNull PlatformContext platformContext) {
        this.metrics = new StateHasherMetrics(platformContext.getMetrics());
    }

    @Override
    @Nullable
    public ReservedSignedState hashState(@NonNull StateWithHashComplexity stateWithHashComplexity) {
        ReservedSignedState reservedSignedState = stateWithHashComplexity.reservedSignedState();
        Instant start = Instant.now();
        reservedSignedState.get().getState().getHash();
        this.metrics.reportHashingTime(Duration.between(start, Instant.now()));
        return reservedSignedState;
    }
}

