/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategies;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.CallAddressChecks;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.CallAttemptOptions;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.CallFactory;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.CallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.SyntheticIds;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.frame.MessageFrame;

@Singleton
public class HtsCallFactory
implements CallFactory<HtsCallAttempt> {
    private final SyntheticIds syntheticIds;
    private final CallAddressChecks addressChecks;
    private final VerificationStrategies verificationStrategies;
    private final List<CallTranslator<HtsCallAttempt>> callTranslators;
    private final SystemContractMethodRegistry systemContractMethodRegistry;

    @Inject
    public HtsCallFactory(@NonNull SyntheticIds syntheticIds, @NonNull CallAddressChecks addressChecks, @NonNull VerificationStrategies verificationStrategies, @Named(value="HtsTranslators") @NonNull List<CallTranslator<HtsCallAttempt>> callTranslators, @NonNull SystemContractMethodRegistry systemContractMethodRegistry) {
        this.syntheticIds = Objects.requireNonNull(syntheticIds);
        this.addressChecks = Objects.requireNonNull(addressChecks);
        this.verificationStrategies = Objects.requireNonNull(verificationStrategies);
        this.callTranslators = Objects.requireNonNull(callTranslators);
        this.systemContractMethodRegistry = Objects.requireNonNull(systemContractMethodRegistry);
    }

    @Override
    @NonNull
    public HtsCallAttempt createCallAttemptFrom(@NonNull ContractID contractID, @NonNull Bytes input, @NonNull FrameUtils.CallType callType, @NonNull MessageFrame frame) {
        Objects.requireNonNull(input);
        Objects.requireNonNull(frame);
        HederaWorldUpdater.Enhancement enhancement = FrameUtils.proxyUpdaterFor(frame).enhancement();
        return new HtsCallAttempt(input, new CallAttemptOptions<HtsCallAttempt>(contractID, frame.getSenderAddress(), callType == FrameUtils.CallType.QUALIFIED_DELEGATE ? frame.getRecipientAddress() : frame.getSenderAddress(), this.addressChecks.hasParentDelegateCall(frame), enhancement, FrameUtils.configOf(frame), this.syntheticIds.converterFor(enhancement.nativeOperations()), this.verificationStrategies, FrameUtils.systemContractGasCalculatorOf(frame), this.callTranslators, this.systemContractMethodRegistry, frame.isStatic()));
    }
}

