/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.service.registry;

import io.helidon.common.types.ResolvedType;
import io.helidon.service.registry.FactoryType;
import io.helidon.service.registry.Lookup;
import io.helidon.service.registry.ServiceInfo;
import java.util.Set;

final class Contracts {
    private Contracts() {
    }

    static ContractLookup create(ServiceInfo descriptor) {
        Set<ResolvedType> contracts = descriptor.contracts();
        return switch (descriptor.factoryType()) {
            case FactoryType.NONE, FactoryType.SERVICE -> new FixedContracts(contracts);
            default -> new ProviderContracts(contracts, descriptor.factoryContracts());
        };
    }

    private static final class FixedContracts
    implements ContractLookup {
        private final Set<ResolvedType> contracts;

        FixedContracts(Set<ResolvedType> contracts) {
            this.contracts = contracts;
        }

        @Override
        public Set<ResolvedType> contracts(Lookup lookup) {
            return this.contracts;
        }
    }

    private static final class ProviderContracts
    implements ContractLookup {
        private final Set<ResolvedType> contracts;
        private final Set<ResolvedType> factoryContracts;

        ProviderContracts(Set<ResolvedType> contracts, Set<ResolvedType> factoryContracts) {
            this.contracts = contracts;
            this.factoryContracts = factoryContracts;
        }

        @Override
        public Set<ResolvedType> contracts(Lookup lookup) {
            return this.contracts;
        }
    }

    static interface ContractLookup {
        public Set<ResolvedType> contracts(Lookup var1);
    }
}

