/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform;

import com.hedera.hapi.node.base.SemanticVersion;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.config.StateConfig;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.service.PlatformStateUtils;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.system.InitTrigger;
import com.swirlds.platform.system.Platform;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.concurrent.interrupt.Uninterruptable;

public final class StateInitializer {
    private static final Logger logger = LogManager.getLogger(StateInitializer.class);

    private StateInitializer() {
    }

    public static void initializeState(@NonNull Platform platform, @NonNull PlatformContext platformContext, @NonNull SignedState signedState, @NonNull ConsensusStateEventHandler consensusStateEventHandler) {
        InitTrigger trigger;
        SemanticVersion previousSoftwareVersion;
        if (signedState.isGenesisState()) {
            previousSoftwareVersion = null;
            trigger = InitTrigger.GENESIS;
        } else {
            previousSoftwareVersion = PlatformStateUtils.creationSoftwareVersionOf((State)signedState.getState());
            trigger = InitTrigger.RESTART;
        }
        MerkleNodeState initialState = signedState.getState();
        if (initialState.isHashed()) {
            throw new IllegalStateException("Expected initial state to be unhashed");
        }
        consensusStateEventHandler.onStateInitialized(signedState.getState(), platform, trigger, previousSoftwareVersion);
        Uninterruptable.abortAndThrowIfInterrupted(() -> ((MerkleNodeState)initialState).getHash(), (String)"interrupted while attempting to hash the state");
        signedState.pruneInvalidSignatures();
        StateConfig stateConfig = (StateConfig)platformContext.getConfiguration().getConfigData(StateConfig.class);
        logger.info(LogMarker.STARTUP.getMarker(), "The platform is using the following initial state:\n{}", (Object)PlatformStateUtils.getInfoString((State)signedState.getState(), stateConfig.debugHashDepth()));
    }
}

