/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.crypto;

import com.hedera.hapi.node.state.roster.RosterEntry;
import com.swirlds.common.utility.CommonUtils;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.Utilities;
import com.swirlds.platform.config.PathsConfig;
import com.swirlds.platform.crypto.EnhancedKeyStoreLoader;
import com.swirlds.platform.crypto.KeyGeneratingException;
import com.swirlds.platform.crypto.KeyLoadingException;
import com.swirlds.platform.crypto.KeysAndCertsGenerator;
import com.swirlds.platform.system.SystemExitCode;
import com.swirlds.platform.system.SystemExitUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import javax.security.auth.x500.X500Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.hiero.base.crypto.CryptographyException;
import org.hiero.consensus.concurrent.framework.config.ThreadConfiguration;
import org.hiero.consensus.concurrent.manager.AdHocThreadManager;
import org.hiero.consensus.config.BasicConfig;
import org.hiero.consensus.crypto.ConsensusCryptoUtils;
import org.hiero.consensus.crypto.CryptoConstants;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;

public final class CryptoStatic {
    private static final Logger logger = LogManager.getLogger(CryptoStatic.class);
    private static final int SERIAL_NUMBER_BITS = 64;
    private static final String LOCAL_NODES_MUST_NOT_BE_NULL = "the local nodes must not be null";

    private CryptoStatic() {
    }

    private static String rdn(String[] commaSeparator, String attributeType, String attributeValue) {
        if (attributeValue == null || attributeValue.isEmpty()) {
            return "";
        }
        attributeValue = attributeValue.replace("\\", "\\\\");
        attributeValue = attributeValue.replace("\"", "\\\"");
        attributeValue = attributeValue.replace(",", "\\,");
        attributeValue = attributeValue.replace(";", "\\;");
        attributeValue = attributeValue.replace("<", "\\<");
        attributeValue = attributeValue.replace(">", "\\>");
        attributeValue = attributeValue.replaceAll(" $", "\\ ");
        attributeValue = attributeValue.replaceAll("^ ", "\\ ");
        attributeValue = attributeValue.replaceAll("^#", "\\#");
        String s = commaSeparator[0] + attributeType + "=" + attributeValue;
        commaSeparator[0] = ",";
        return s;
    }

    static String distinguishedName(String commonName) {
        String[] commaSeparator = new String[]{""};
        return CryptoStatic.rdn(commaSeparator, "CN", commonName) + CryptoStatic.rdn(commaSeparator, "O", null) + CryptoStatic.rdn(commaSeparator, "STREET", null) + CryptoStatic.rdn(commaSeparator, "L", null) + CryptoStatic.rdn(commaSeparator, "ST", null) + CryptoStatic.rdn(commaSeparator, "C", null) + CryptoStatic.rdn(commaSeparator, "UID", null);
    }

    public static X509Certificate generateCertificate(String distinguishedName, KeyPair pair, String caDistinguishedName, KeyPair caPair, SecureRandom secureRandom, String signatureAlgorithm) throws KeyGeneratingException {
        try {
            JcaX509v3CertificateBuilder v3CertBldr = new JcaX509v3CertificateBuilder(new X500Principal(caDistinguishedName), new BigInteger(64, secureRandom), Date.from(CryptoConstants.DEFAULT_VALID_FROM), Date.from(CryptoConstants.DEFAULT_VALID_TO), new X500Principal(distinguishedName), pair.getPublic());
            JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder(signatureAlgorithm).setProvider("BC");
            return new JcaX509CertificateConverter().setProvider("BC").getCertificate(v3CertBldr.build(signerBuilder.build(caPair.getPrivate())));
        }
        catch (CertificateException | OperatorCreationException e) {
            throw new KeyGeneratingException("Could not generate certificate!", e);
        }
    }

    @NonNull
    public static KeyStore loadKeys(@NonNull Path file, @NonNull char[] password) throws KeyStoreException, KeyLoadingException {
        KeyStore store = ConsensusCryptoUtils.createEmptyTrustStore();
        try (FileInputStream fis = new FileInputStream(file.toFile());){
            store.load(fis, password);
            if (store.size() == 0) {
                throw new KeyLoadingException("there are no valid keys or certificates in " + String.valueOf(file));
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new KeyLoadingException("there was a problem reading: " + String.valueOf(file), e);
        }
        return store;
    }

    @NonNull
    public static Map<NodeId, KeysAndCerts> generateKeysAndCerts(@NonNull Collection<NodeId> nodeIds) throws ExecutionException, InterruptedException, KeyStoreException {
        HashMap futures = HashMap.newHashMap(nodeIds.size());
        try (ExecutorService threadPool = Executors.newCachedThreadPool(((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent("browser")).setThreadName("crypto-generate")).setDaemon(false)).buildFactory());){
            for (NodeId nodeId : nodeIds) {
                futures.put(nodeId, threadPool.submit(() -> KeysAndCertsGenerator.generate(nodeId)));
            }
            Map<NodeId, KeysAndCerts> keysAndCerts = CryptoStatic.futuresToMap(futures);
            threadPool.shutdown();
            Map<NodeId, KeysAndCerts> map = keysAndCerts;
            return map;
        }
    }

    @NonNull
    private static <T> Map<NodeId, T> futuresToMap(@NonNull Map<NodeId, Future<T>> futures) throws ExecutionException, InterruptedException {
        HashMap<NodeId, T> map = new HashMap<NodeId, T>();
        for (Map.Entry<NodeId, Future<T>> entry : futures.entrySet()) {
            map.put(entry.getKey(), entry.getValue().get());
        }
        return map;
    }

    public static KeysAndCerts initNodeSecurity(@NonNull Configuration configuration, @NonNull NodeId localNode, @NonNull List<RosterEntry> rosterEntries) {
        Map<NodeId, KeysAndCerts> keysAndCerts;
        BasicConfig basicConfig;
        block11: {
            Objects.requireNonNull(configuration, "configuration must not be null");
            Objects.requireNonNull(localNode, LOCAL_NODES_MUST_NOT_BE_NULL);
            PathsConfig pathsConfig = (PathsConfig)configuration.getConfigData(PathsConfig.class);
            basicConfig = (BasicConfig)configuration.getConfigData(BasicConfig.class);
            try {
                if (basicConfig.loadKeysFromPfxFiles()) {
                    try (Stream<Path> list = Files.list(pathsConfig.getKeysDirPath());){
                        CommonUtils.tellUserConsole((String)("Reading crypto keys from the files here:   " + Arrays.toString(list.map(p -> p.getFileName().toString()).filter(fileName -> fileName.endsWith("pfx") || fileName.endsWith("pem")).toArray())));
                    }
                    logger.debug(LogMarker.STARTUP.getMarker(), "About to start loading keys");
                    logger.debug(LogMarker.STARTUP.getMarker(), "Reading keys using the enhanced key loader");
                    keysAndCerts = EnhancedKeyStoreLoader.using(configuration, Set.of(localNode), rosterEntries).migrate().scan().generate().verify().keysAndCerts();
                    logger.debug(LogMarker.STARTUP.getMarker(), "Done loading keys");
                    break block11;
                }
                CommonUtils.tellUserConsole((String)("Keys will be generated in: " + String.valueOf(pathsConfig.getKeysDirPath()) + ", which is incompatible with DAB."));
                logger.warn(LogMarker.STARTUP.getMarker(), "There are no keys on disk, Adhoc keys will be generated, but this is incompatible with DAB.");
                logger.debug(LogMarker.STARTUP.getMarker(), "Started generating keys");
                keysAndCerts = CryptoStatic.generateKeysAndCerts(Set.of(localNode));
                logger.debug(LogMarker.STARTUP.getMarker(), "Done generating keys");
            }
            catch (KeyGeneratingException | KeyLoadingException | IOException | InterruptedException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | ExecutionException e) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Exception while loading/generating keys", (Throwable)e);
                if (Utilities.isRootCauseSuppliedType(e, NoSuchAlgorithmException.class) || Utilities.isRootCauseSuppliedType(e, NoSuchProviderException.class)) {
                    CommonUtils.tellUserConsolePopup((String)"ERROR", (String)"ERROR: This Java installation does not have the needed cryptography providers installed");
                }
                SystemExitUtils.exitSystem(SystemExitCode.KEY_LOADING_FAILED);
                throw new CryptographyException((Throwable)e);
            }
        }
        String msg = basicConfig.loadKeysFromPfxFiles() ? "Certificate loaded: {}" : "Certificate generated: {}";
        keysAndCerts.forEach((nodeId, keysAndCertsForNode) -> {
            if (keysAndCertsForNode == null) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "No keys and certs for node {}", nodeId);
                return;
            }
            logger.debug(LogMarker.CERTIFICATES.getMarker(), "Node ID: {}", nodeId);
            logger.debug(LogMarker.CERTIFICATES.getMarker(), msg, (Object)keysAndCertsForNode.sigCert());
            logger.debug(LogMarker.CERTIFICATES.getMarker(), msg, (Object)keysAndCertsForNode.agrCert());
        });
        return keysAndCerts.get(localNode);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

