/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui.internal;

import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.gui.components.PrePaintableJPanel;
import com.swirlds.platform.gui.hashgraph.HashgraphGui;
import com.swirlds.platform.gui.hashgraph.HashgraphGuiSource;
import com.swirlds.platform.gui.internal.WinBrowser;
import com.swirlds.platform.gui.internal.WinTab2Consensus;
import com.swirlds.platform.gui.internal.WinTab2Stats;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.hiero.consensus.hashgraph.impl.consensus.Consensus;
import org.hiero.consensus.model.node.NodeId;

class WinTabNetwork
extends PrePaintableJPanel {
    private static final long serialVersionUID = 1L;
    private boolean didInit = false;
    JTabbedPane tabbed = new JTabbedPane(2, 0);
    private final WinTab2Stats tabStats;
    private final HashgraphGui tabHashgraph;
    private final WinTab2Consensus tabConsensus;

    public WinTabNetwork(@NonNull NodeId firstNodeId, @NonNull HashgraphGuiSource hashgraphSource, @NonNull Consensus consensus, @NonNull Metrics guiMetrics) {
        this.tabStats = new WinTab2Stats(guiMetrics);
        this.tabHashgraph = new HashgraphGui(hashgraphSource);
        this.tabConsensus = new WinTab2Consensus(consensus, firstNodeId);
        Rectangle winRect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Dimension d = new Dimension(winRect.width - 20, winRect.height - 110);
        this.setLocation(winRect.x, winRect.y);
        this.setFocusable(true);
        this.requestFocusInWindow();
        this.tabbed.addTab("Stats", this.tabStats);
        this.tabbed.addTab("Hashgraph", this.tabHashgraph);
        this.tabbed.addTab("Consensus", this.tabConsensus);
        this.tabbed.setSelectedComponent(this.tabStats);
        this.tabbed.addChangeListener(new ChangeListener(this){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof JTabbedPane) {
                    WinBrowser.prePaintThenRepaint();
                }
            }
        });
        this.setBackground(Color.WHITE);
        this.tabbed.setBackground(Color.WHITE);
        this.tabStats.setBackground(Color.WHITE);
        this.tabHashgraph.setBackground(Color.WHITE);
        this.tabConsensus.setBackground(Color.WHITE);
        this.tabStats.setMinimumSize(d);
        this.tabHashgraph.setMaximumSize(d);
        this.tabConsensus.setMaximumSize(d);
        this.add(this.tabbed);
        this.setVisible(true);
        this.revalidate();
    }

    @Override
    public void prePaint() {
        Component comp;
        if (this.tabbed == null) {
            return;
        }
        if (!this.didInit && WinBrowser.memberDisplayed != null) {
            this.didInit = true;
            this.tabStats.prePaint();
            this.tabHashgraph.prePaint();
            this.tabConsensus.prePaint();
        }
        if (!((comp = this.tabbed.getSelectedComponent()) instanceof PrePaintableJPanel)) {
            return;
        }
        PrePaintableJPanel panel = (PrePaintableJPanel)comp;
        panel.prePaint();
    }

    void goTab(int n) {
        this.requestFocus(true);
        this.tabbed.setSelectedIndex(n);
        WinBrowser.prePaintThenRepaint();
    }
}

