/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network;

import com.swirlds.base.time.Time;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.ConnectionTracker;
import com.swirlds.platform.network.DedicatedStoppableThread;
import com.swirlds.platform.network.NetworkMetrics;
import com.swirlds.platform.network.NetworkUtils;
import com.swirlds.platform.network.PeerConnectionServer;
import com.swirlds.platform.network.PeerInfo;
import com.swirlds.platform.network.communication.NegotiationProtocols;
import com.swirlds.platform.network.communication.ProtocolNegotiatorThread;
import com.swirlds.platform.network.connectivity.InboundConnectionHandler;
import com.swirlds.platform.network.connectivity.SocketFactory;
import com.swirlds.platform.network.protocol.Protocol;
import com.swirlds.platform.network.protocol.ProtocolRunnable;
import com.swirlds.platform.network.topology.ConnectionManagerFactory;
import com.swirlds.platform.network.topology.DynamicConnectionManagers;
import com.swirlds.platform.network.topology.StaticTopology;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.concurrent.interrupt.InterruptableConsumer;
import org.hiero.base.concurrent.interrupt.InterruptableRunnable;
import org.hiero.base.concurrent.locks.AutoClosableLock;
import org.hiero.base.concurrent.locks.Locks;
import org.hiero.base.concurrent.locks.locked.Locked;
import org.hiero.consensus.concurrent.framework.StoppableThread;
import org.hiero.consensus.concurrent.framework.TypedStoppableThread;
import org.hiero.consensus.concurrent.framework.config.StoppableThreadConfiguration;
import org.hiero.consensus.concurrent.manager.ThreadManager;
import org.hiero.consensus.config.BasicConfig;
import org.hiero.consensus.config.ThreadConfig;
import org.hiero.consensus.gossip.config.SocketConfig;
import org.hiero.consensus.gossip.config.SyncConfig;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;

public class PeerCommunication
implements ConnectionTracker {
    private static final Logger logger = LogManager.getLogger(PeerCommunication.class);
    public static final String PLATFORM_THREAD_POOL_NAME = "platform-core";
    private final AutoClosableLock peerLock = Locks.createAutoLock();
    private final NetworkMetrics networkMetrics;
    private StaticTopology topology;
    private final KeysAndCerts ownKeysAndCerts;
    private final Configuration configuration;
    private final Time time;
    private List<PeerInfo> peers;
    private final PeerInfo selfPeer;
    private DynamicConnectionManagers connectionManagers;
    private ThreadManager threadManager;
    private final NodeId selfId;
    private List<ProtocolRunnable> handshakeProtocols;
    private List<Protocol> protocolList;
    private PeerConnectionServer connectionServer;
    private final Map<Object, DedicatedStoppableThread<NodeId>> dedicatedThreads = new HashMap<Object, DedicatedStoppableThread<NodeId>>();
    private final List<DedicatedStoppableThread<NodeId>> dedicatedThreadsToModify = new ArrayList<DedicatedStoppableThread<NodeId>>();
    private boolean started = false;
    private TypedStoppableThread<InterruptableRunnable> connectionServerThread;

    public PeerCommunication(@NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time, @NonNull List<PeerInfo> peers, @NonNull PeerInfo selfPeer, @NonNull KeysAndCerts ownKeysAndCerts) {
        this.configuration = Objects.requireNonNull(configuration);
        this.time = Objects.requireNonNull(time);
        this.ownKeysAndCerts = Objects.requireNonNull(ownKeysAndCerts);
        this.peers = Collections.unmodifiableList(Objects.requireNonNull(peers));
        this.selfPeer = Objects.requireNonNull(selfPeer);
        this.selfId = selfPeer.nodeId();
        this.networkMetrics = new NetworkMetrics(metrics, selfPeer.nodeId(), peers);
        metrics.addUpdater(this.networkMetrics::update);
        this.topology = new StaticTopology(peers, selfPeer.nodeId());
    }

    public void initialize(@NonNull ThreadManager threadManager, @NonNull List<ProtocolRunnable> handshakeProtocols, @NonNull List<Protocol> protocols) {
        this.threadManager = threadManager;
        this.handshakeProtocols = handshakeProtocols;
        this.protocolList = protocols;
        this.connectionManagers = new DynamicConnectionManagers(this.configuration, this.time, this.selfId, this.peers, this, this.ownKeysAndCerts, this.topology, ConnectionManagerFactory.DEFAULT);
        this.connectionServer = this.createConnectionServer();
        ThreadConfig threadConfig = (ThreadConfig)this.configuration.getConfigData(ThreadConfig.class);
        this.connectionServerThread = ((StoppableThreadConfiguration)((StoppableThreadConfiguration)((StoppableThreadConfiguration)((StoppableThreadConfiguration)new StoppableThreadConfiguration(threadManager).setPriority(threadConfig.threadPrioritySync())).setNodeId(this.selfId)).setComponent(PLATFORM_THREAD_POOL_NAME)).setThreadName("connectionServer")).setWork((InterruptableRunnable)this.connectionServer).build();
        this.registerDedicatedThreads(this.buildProtocolThreads(this.topology.getNeighbors()));
    }

    public NetworkMetrics getNetworkMetrics() {
        return this.networkMetrics;
    }

    public void addRemovePeers(@NonNull List<PeerInfo> added, @NonNull List<PeerInfo> removed) {
        Objects.requireNonNull(added);
        Objects.requireNonNull(removed);
        if (added.isEmpty() && removed.isEmpty()) {
            return;
        }
        ArrayList<DedicatedStoppableThread<NodeId>> threads = new ArrayList<DedicatedStoppableThread<NodeId>>();
        try (Locked ignored = this.peerLock.lock();){
            HashMap<NodeId, PeerInfo> newPeers = new HashMap<NodeId, PeerInfo>();
            for (PeerInfo peer : this.peers) {
                newPeers.put(peer.nodeId(), peer);
            }
            for (PeerInfo peerInfo : removed) {
                PeerInfo previousPeer = (PeerInfo)newPeers.remove(peerInfo.nodeId());
                if (previousPeer == null) {
                    logger.warn("Peer info for nodeId: {} not found for removal", (Object)peerInfo.nodeId());
                    continue;
                }
                threads.add(new DedicatedStoppableThread<NodeId>(peerInfo.nodeId(), null));
            }
            for (PeerInfo peerInfo : added) {
                PeerInfo oldData = newPeers.put(peerInfo.nodeId(), peerInfo);
                if (oldData == null) continue;
                logger.warn("Peer info for nodeId: {} replaced without removal, new data {}, old data {}", (Object)peerInfo.nodeId(), (Object)peerInfo, (Object)oldData);
            }
            this.peers = List.copyOf(newPeers.values());
            this.topology = new StaticTopology(this.peers, this.selfPeer.nodeId());
            this.connectionManagers.addRemovePeers(added, removed, this.topology);
            this.connectionServer.replacePeers(this.peers);
            threads.addAll(this.buildProtocolThreads(added.stream().map(PeerInfo::nodeId).toList()));
            this.registerDedicatedThreads(threads);
            this.applyDedicatedThreadsToModify();
        }
    }

    @Override
    public void newConnectionOpened(@NonNull Connection sc) {
        Objects.requireNonNull(sc);
        this.networkMetrics.connectionEstablished(sc);
    }

    @Override
    public void connectionClosed(boolean outbound, @NonNull Connection conn) {
        Objects.requireNonNull(conn);
        this.networkMetrics.recordDisconnect(conn);
    }

    public void start() {
        if (this.started) {
            throw new IllegalStateException("Gossip already started");
        }
        this.started = true;
        this.connectionServerThread.start();
        this.applyDedicatedThreadsToModify();
    }

    public void stop() {
        if (!this.started) {
            throw new IllegalStateException("Gossip not started");
        }
        this.connectionServerThread.stop();
        for (DedicatedStoppableThread<NodeId> dst : this.dedicatedThreads.values()) {
            dst.thread().interrupt();
            dst.thread().stop();
        }
    }

    private List<DedicatedStoppableThread<NodeId>> buildProtocolThreads(Collection<NodeId> peers) {
        SyncConfig syncConfig = (SyncConfig)this.configuration.getConfigData(SyncConfig.class);
        BasicConfig basicConfig = (BasicConfig)this.configuration.getConfigData(BasicConfig.class);
        Duration hangingThreadDuration = basicConfig.hangingThreadDuration();
        ArrayList<DedicatedStoppableThread<NodeId>> syncProtocolThreads = new ArrayList<DedicatedStoppableThread<NodeId>>();
        for (NodeId otherId : peers) {
            syncProtocolThreads.add(new DedicatedStoppableThread<NodeId>(otherId, (StoppableThread)((StoppableThreadConfiguration)((StoppableThreadConfiguration)((StoppableThreadConfiguration)((StoppableThreadConfiguration)((StoppableThreadConfiguration)((StoppableThreadConfiguration)new StoppableThreadConfiguration(this.threadManager).setPriority(5)).setNodeId(this.selfId)).setComponent(PLATFORM_THREAD_POOL_NAME)).setOtherNodeId(otherId)).setThreadName("SyncProtocolWith" + String.valueOf(otherId))).setHangingThreadPeriod(hangingThreadDuration)).setWork((InterruptableRunnable)new ProtocolNegotiatorThread(this.connectionManagers.getManager(otherId), syncConfig.syncSleepAfterFailedNegotiation(), this.handshakeProtocols, new NegotiationProtocols(this.protocolList.stream().map(protocol -> protocol.createPeerInstance(otherId)).toList()), this.time)).build()));
        }
        return syncProtocolThreads;
    }

    private PeerConnectionServer createConnectionServer() {
        InboundConnectionHandler inboundConnectionHandler = new InboundConnectionHandler(this.configuration, this.time, this, this.peers, this.selfId, (InterruptableConsumer<Connection>)((InterruptableConsumer)this.connectionManagers::newConnection));
        SocketFactory socketFactory = NetworkUtils.createSocketFactory(this.selfId, this.peers, this.ownKeysAndCerts, this.configuration);
        return new PeerConnectionServer(this.threadManager, this.selfPeer.port(), inboundConnectionHandler, socketFactory, ((SocketConfig)this.configuration.getConfigData(SocketConfig.class)).maxSocketAcceptThreads());
    }

    private void registerDedicatedThreads(@NonNull Collection<DedicatedStoppableThread<NodeId>> things) {
        Objects.requireNonNull(things);
        this.dedicatedThreadsToModify.addAll(things);
    }

    private void applyDedicatedThreadsToModify() {
        if (!this.started) {
            logger.warn("Cannot apply dedicated threads status when gossip is not started");
            return;
        }
        for (DedicatedStoppableThread<NodeId> dst : this.dedicatedThreadsToModify) {
            StoppableThread newThread = dst.thread();
            DedicatedStoppableThread<NodeId> oldThread = this.dedicatedThreads.remove(dst.key());
            if (newThread == null) {
                if (oldThread != null && oldThread.thread() != null) {
                    oldThread.thread().interrupt();
                    continue;
                }
                logger.warn("Dedicated thread {} was not found, but we were asked to stop it", (Object)dst.key());
                continue;
            }
            if (oldThread != null && oldThread.thread() != null) {
                oldThread.thread().interrupt();
            }
            this.dedicatedThreads.put(dst.key(), dst);
            newThread.start();
        }
        this.dedicatedThreadsToModify.clear();
    }
}

