/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl;

import com.hedera.hapi.block.stream.MerklePath;
import com.hedera.hapi.block.stream.MerkleSiblingHash;
import com.hedera.hapi.block.stream.SiblingNode;
import com.hedera.hapi.block.stream.StateProof;
import com.hedera.hapi.block.stream.TssSignedBlockProof;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.blockstream.MerkleLeaf;
import com.hedera.node.app.blocks.impl.BlockImplUtils;
import com.hedera.node.app.blocks.impl.PendingBlock;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.SiblingHash;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.stream.Streams;
import org.hiero.base.crypto.Hash;

public class BlockStateProofGenerator {
    public static final int UNSIGNED_BLOCK_SIBLING_COUNT = 4;
    public static final int SIGNED_BLOCK_SIBLING_COUNT = 3;
    public static final int EXPECTED_MERKLE_PATH_COUNT = 3;
    public static final int BLOCK_CONTENTS_PATH_INDEX = 1;
    public static final int FINAL_MERKLE_PATH_INDEX = 2;
    public static final int FINAL_NEXT_PATH_INDEX = -1;

    public static StateProof generateStateProof(@NonNull PendingBlock currentPendingBlock, long latestSignedBlockNumber, Bytes latestSignedBlockSignature, Timestamp latestSignedBlockTimestamp, @NonNull Stream<PendingBlock> remainingPendingBlocks) {
        long minBlockNum;
        Map allPendingBlocks = Streams.of((Object[])new Stream[]{Stream.of(currentPendingBlock), remainingPendingBlocks}).flatMap(s -> s).collect(Collectors.toMap(PendingBlock::number, Function.identity()));
        Map<Long, PendingBlock> indirectProofBlocks = allPendingBlocks.entrySet().stream().filter(e -> (Long)e.getKey() < latestSignedBlockNumber).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Bytes tsBytes = Timestamp.PROTOBUF.toBytes((Object)latestSignedBlockTimestamp);
        MerkleLeaf tsLeaf = MerkleLeaf.newBuilder().blockConsensusTimestamp(tsBytes).build();
        MerklePath.Builder mp1 = MerklePath.newBuilder().leaf(tsLeaf).nextPathIndex(2);
        MerklePath.Builder mp2 = MerklePath.newBuilder().hash(currentPendingBlock.previousBlockHash()).nextPathIndex(2);
        int totalSiblings = indirectProofBlocks.size() * 4 + 3;
        SiblingNode[] allSiblingHashes = new SiblingNode[totalSiblings];
        long currentBlockNum = minBlockNum = currentPendingBlock.number();
        for (int i = 0; i < indirectProofBlocks.size(); ++i) {
            List<SiblingHash> blockSiblings = Arrays.stream(indirectProofBlocks.get(currentBlockNum).siblingHashes()).map(s -> new SiblingHash(!s.isFirst(), new Hash(s.siblingHash()))).toList();
            int firstSiblingIndex = i * 4;
            for (int j = 0; j < blockSiblings.size(); ++j) {
                SiblingHash blockSibling = blockSiblings.get(j);
                allSiblingHashes[firstSiblingIndex + j] = SiblingNode.newBuilder().isLeft(!blockSibling.isRight()).hash(blockSibling.hash().getBytes()).build();
            }
            Bytes pbTsBytes = BlockImplUtils.hashLeaf(Timestamp.PROTOBUF.toBytes((Object)indirectProofBlocks.get(currentBlockNum).blockTimestamp()));
            int pendingBlockTimestampSiblingIndex = firstSiblingIndex + 4 - 1;
            allSiblingHashes[pendingBlockTimestampSiblingIndex] = SiblingNode.newBuilder().isLeft(true).hash(pbTsBytes).build();
            ++currentBlockNum;
        }
        PendingBlock signedBlock = (PendingBlock)allPendingBlocks.get(latestSignedBlockNumber);
        MerkleSiblingHash[] signedBlockSiblings = signedBlock.siblingHashes();
        int signedBlockFirstSiblingIndex = indirectProofBlocks.size() * 4;
        for (int i = 0; i < signedBlockSiblings.length; ++i) {
            MerkleSiblingHash blockSibling = signedBlockSiblings[i];
            allSiblingHashes[signedBlockFirstSiblingIndex + i] = SiblingNode.newBuilder().isLeft(blockSibling.isFirst()).hash(blockSibling.siblingHash()).build();
        }
        mp2.siblings(Arrays.stream(allSiblingHashes).toList());
        MerklePath.Builder mp3 = MerklePath.newBuilder().nextPathIndex(-1);
        return StateProof.newBuilder().paths(new MerklePath[]{mp1.build(), mp2.build(), mp3.build()}).signedBlockProof(TssSignedBlockProof.newBuilder().blockSignature(latestSignedBlockSignature)).build();
    }
}

