/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.metrics.platform;

import com.swirlds.base.time.Time;
import com.swirlds.base.utility.ToStringBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.consensus.metrics.SpeedometerMetric;
import org.hiero.consensus.metrics.platform.AbstractDistributionMetric;
import org.hiero.consensus.metrics.statistics.StatsBuffered;
import org.hiero.consensus.metrics.statistics.StatsSpeedometer;

public class PlatformSpeedometerMetric
extends AbstractDistributionMetric
implements SpeedometerMetric {
    private final StatsSpeedometer speedometer;

    public PlatformSpeedometerMetric(@NonNull SpeedometerMetric.Config config) {
        this(config, Time.getCurrent());
    }

    public PlatformSpeedometerMetric(SpeedometerMetric.Config config, Time time) {
        super(config, config.getHalfLife());
        this.speedometer = new StatsSpeedometer(this.halfLife, time);
    }

    @Override
    @NonNull
    public StatsBuffered getStatsBuffered() {
        return this.speedometer;
    }

    @Override
    public void update(double value) {
        this.speedometer.update(value);
    }

    @Override
    public void cycle() {
        this.update(1.0);
    }

    @Override
    public double get() {
        return this.speedometer.getCyclesPerSecond();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("halfLife", (Object)this.halfLife).append("value", (Object)this.get()).toString();
    }
}

