/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.metrics.statistics;

import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hiero.consensus.metrics.statistics.AverageAndMaxTimeStat;

public class EventPipelineTracker {
    private final Metrics metrics;
    private final Map<String, AverageAndMaxTimeStat> metricMap = new HashMap<String, AverageAndMaxTimeStat>();

    public EventPipelineTracker(@NonNull Metrics metrics) {
        this.metrics = Objects.requireNonNull(metrics);
    }

    public void registerMetric(@NonNull String name) {
        int step = this.metricMap.size() + 1;
        AverageAndMaxTimeStat stat = new AverageAndMaxTimeStat(this.metrics, ChronoUnit.MICROS, "platform", "eventDelay_%d_%s".formatted(step, name), "event pipeline delay until after " + name);
        this.metricMap.put(name, stat);
    }

    public void recordEvent(@NonNull String name, @NonNull Instant start) {
        AverageAndMaxTimeStat stat = this.metricMap.get(name);
        if (stat == null) {
            throw new IllegalArgumentException("No metric registered for stage: " + name);
        }
        stat.update(start);
    }

    public void recordEvents(@NonNull String name, @NonNull List<Instant> starts) {
        AverageAndMaxTimeStat stat = this.metricMap.get(name);
        if (stat != null) {
            for (Instant start : starts) {
                stat.update(start);
            }
        } else {
            throw new IllegalArgumentException("No metric registered for stage: " + name);
        }
    }
}

