/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.http2.Http2Util;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.http2.Http2Config;
import io.helidon.webserver.http2.Http2Connection;
import io.helidon.webserver.http2.spi.Http2SubProtocolSelector;
import io.helidon.webserver.spi.ServerConnection;
import io.helidon.webserver.spi.ServerConnectionSelector;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Http2ConnectionSelector
implements ServerConnectionSelector {
    private final Http2Config http2Config;
    private final List<Http2SubProtocolSelector> subProviders;

    Http2ConnectionSelector(Http2Config http2Config, List<Http2SubProtocolSelector> subProviders) {
        this.http2Config = http2Config;
        this.subProviders = subProviders;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int bytesToIdentifyConnection() {
        return Http2Util.PREFACE_LENGTH;
    }

    public ServerConnectionSelector.Support supports(BufferData request) {
        byte[] prefaceBytes = new byte[Http2Util.PREFACE_LENGTH];
        request.read(prefaceBytes, 0, Http2Util.PREFACE_LENGTH);
        if (Http2Util.isPreface((byte[])prefaceBytes)) {
            return ServerConnectionSelector.Support.SUPPORTED;
        }
        return ServerConnectionSelector.Support.UNSUPPORTED;
    }

    public Set<String> supportedApplicationProtocols() {
        return Set.of("h2");
    }

    public ServerConnection connection(ConnectionContext ctx) {
        Http2Connection result = new Http2Connection(ctx, this.http2Config, this.subProviders);
        result.expectPreface();
        return result;
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, Http2ConnectionSelector> {
        private final List<Http2SubProtocolSelector> subProtocolSelectors = new ArrayList<Http2SubProtocolSelector>();
        private Http2Config http2Config;

        private Builder() {
        }

        public Http2ConnectionSelector build() {
            return new Http2ConnectionSelector(this.http2Config, this.subProtocolSelectors);
        }

        public Builder http2Config(Http2Config http2Config) {
            this.http2Config = http2Config;
            return this;
        }

        public Builder addSubProtocolSelector(Http2SubProtocolSelector selector) {
            this.subProtocolSelectors.add(selector);
            return this;
        }
    }
}

