/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pcli;

import com.swirlds.platform.health.clock.OSClockSourceSpeedCheck;
import com.swirlds.platform.health.entropy.OSEntropyCheck;
import com.swirlds.platform.health.filesystem.OSFileSystemCheck;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.file.Path;
import org.hiero.consensus.pcli.AbstractCommand;
import org.hiero.consensus.pcli.Pcli;
import org.hiero.consensus.pcli.SubcommandOf;
import picocli.CommandLine;

@CommandLine.Command(name="health-check", mixinStandardHelpOptions=true, description={"Executes basic OS health checks and reports results"})
@SubcommandOf(value=Pcli.class)
public class HealthCheckCommand
extends AbstractCommand {
    private String file;
    private int clockLimit;
    private double randomLimit;
    private double fileLimit;

    @CommandLine.Option(names={"-f", "--file"}, description={"Path to existing non-empty file on which read performance will be checked"})
    private void setFile(@NonNull String file) {
        this.file = file;
    }

    @CommandLine.Option(names={"--clock-limit"}, description={"Minimum amount of calls per second for clock check to pass"})
    private void setClockLimit(int clockLimit) {
        this.clockLimit = clockLimit;
    }

    @CommandLine.Option(names={"--random-limit"}, description={"Maximum time (in ms) for random entropy generator to count as a pass"})
    private void setRandomLimit(double randomLimit) {
        this.randomLimit = randomLimit;
    }

    @CommandLine.Option(names={"--file-limit"}, description={"Maximum time (in ms) for file read check to count as a pass"})
    private void setFileLimit(double fileLimit) {
        this.fileLimit = fileLimit;
    }

    @Override
    public Integer call() throws Exception {
        System.out.println("Please be warned - all these statistics are printed for non-warmed JVM, so they are not representative of the real world performance");
        long clockSpeed = HealthCheckCommand.printOSClockSourceSpeedReport();
        double randomSpeed = HealthCheckCommand.printOSEntropyReport();
        if (this.file != null) {
            double fileSpeed = HealthCheckCommand.printOSFileSystemReport(Path.of(this.file, new String[0]));
            if (this.fileLimit > 0.0 && fileSpeed > this.fileLimit) {
                System.out.printf("File read time too big, above limit of %f ms%n", this.fileLimit);
                return 3;
            }
        }
        if (this.clockLimit > 0 && clockSpeed < (long)this.clockLimit) {
            System.out.printf("Clock speed not good enough, below limit of %d calls/sec%n", this.clockLimit);
            return 1;
        }
        if (this.randomLimit > 0.0 && randomSpeed > this.randomLimit) {
            System.out.printf("Random entropy time too big, above limit of %f ms%n", this.randomLimit);
            return 2;
        }
        return 0;
    }

    public static long printOSClockSourceSpeedReport() {
        OSClockSourceSpeedCheck.Report clockSpeedReport = OSClockSourceSpeedCheck.execute();
        System.out.printf("Average clock source speed: %d calls/sec%n", clockSpeedReport.callsPerSec());
        return clockSpeedReport.callsPerSec();
    }

    public static double printOSEntropyReport() {
        try {
            OSEntropyCheck.Report randomSpeed = OSEntropyCheck.execute();
            if (randomSpeed.success()) {
                double elapsedMillis = (double)randomSpeed.elapsedNanos().longValue() * 1.0E-6;
                System.out.printf("First random number generation time: %d nanos (%s millis), generated long=%d%n", randomSpeed.elapsedNanos(), elapsedMillis, randomSpeed.randomLong());
                return elapsedMillis;
            }
            System.out.println("Random number generation check failed due to timeout");
            return Double.POSITIVE_INFINITY;
        }
        catch (InterruptedException e) {
            System.out.println("Thread interrupted while measuring the random number generation speed");
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static double printOSFileSystemReport(Path fileToRead) {
        try {
            OSFileSystemCheck.Report report = OSFileSystemCheck.execute((Path)fileToRead);
            if (report.code() == OSFileSystemCheck.TestResultCode.SUCCESS) {
                double elapsedMillis = (double)report.readNanos().longValue() * 1.0E-6;
                System.out.printf("File system check, took %d nanos (%s millis) to open the file and read 1 byte (data=%s)%n", report.readNanos(), elapsedMillis, report.data());
                return elapsedMillis;
            }
            if (report.exception() == null) {
                System.out.printf("File system check failed. Reason: %s%n", report.code());
            } else {
                System.out.printf("File system check failed with exception. Reason: %s%n%s%n", report.code(), report.exception());
            }
            return Double.POSITIVE_INFINITY;
        }
        catch (InterruptedException e) {
            System.out.println("Thread interrupted while checking the file system");
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

