/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pcli.graph;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.platform.gossip.NoOpIntakeEventCounter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.hiero.consensus.crypto.PbjStreamHasher;
import org.hiero.consensus.event.IntakeEventCounter;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.orphan.DefaultOrphanBuffer;
import org.hiero.consensus.pcli.graph.EventGraphSource;

public class OrphanBufferEventGraphSource
implements EventGraphSource {
    private final EventGraphSource underlyingSource;
    private final PbjStreamHasher eventHasher;
    private final DefaultOrphanBuffer orphanBuffer;
    private final LinkedList<PlatformEvent> releasedEventsBuffer;

    public OrphanBufferEventGraphSource(@NonNull EventGraphSource underlyingSource, @NonNull PlatformContext context) {
        this.underlyingSource = underlyingSource;
        this.eventHasher = new PbjStreamHasher();
        this.orphanBuffer = new DefaultOrphanBuffer(context.getMetrics(), (IntakeEventCounter)new NoOpIntakeEventCounter());
        this.releasedEventsBuffer = new LinkedList();
    }

    @Override
    @NonNull
    public PlatformEvent next() {
        this.storeOneIntoBufferIfPossible();
        if (this.releasedEventsBuffer.isEmpty()) {
            throw new NoSuchElementException("No more events available");
        }
        return this.releasedEventsBuffer.removeFirst();
    }

    @Override
    public boolean hasNext() {
        this.storeOneIntoBufferIfPossible();
        return !this.releasedEventsBuffer.isEmpty();
    }

    private void storeOneIntoBufferIfPossible() {
        while (this.releasedEventsBuffer.isEmpty() && this.underlyingSource.hasNext()) {
            this.processNextEvent();
        }
    }

    private void processNextEvent() {
        PlatformEvent event = this.underlyingSource.next();
        this.eventHasher.hashEvent(event);
        List releasedEvents = this.orphanBuffer.handleEvent(event);
        this.releasedEventsBuffer.addAll(releasedEvents);
    }

    public void setEventWindow(@NonNull EventWindow eventWindow) {
        List releasedEvents = this.orphanBuffer.setEventWindow(eventWindow);
        this.releasedEventsBuffer.addAll(releasedEvents);
    }
}

