/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gui.internal;

import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.SwirldsPlatform;
import com.swirlds.platform.gui.components.ScrollableJPanel;
import com.swirlds.platform.gui.internal.StateHierarchy;
import com.swirlds.platform.gui.internal.WinBrowser;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collection;

public final class BrowserWindowManager {
    private static Metrics metrics;
    private static WinBrowser browserWindow;
    private static StateHierarchy stateHierarchy;
    private static final Collection<SwirldsPlatform> platforms;

    private BrowserWindowManager() {
    }

    public static WinBrowser getBrowserWindow() {
        return browserWindow;
    }

    public static void setBrowserWindow(WinBrowser browserWindow) {
        BrowserWindowManager.browserWindow = browserWindow;
    }

    public static StateHierarchy getStateHierarchy() {
        return stateHierarchy;
    }

    public static void setStateHierarchy(StateHierarchy stateHierarchy) {
        BrowserWindowManager.stateHierarchy = stateHierarchy;
    }

    public static Collection<SwirldsPlatform> getPlatforms() {
        return platforms;
    }

    public static void showBrowserWindow(@Nullable ScrollableJPanel comp) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        if (BrowserWindowManager.getBrowserWindow() != null) {
            BrowserWindowManager.getBrowserWindow().setVisible(true);
            return;
        }
        BrowserWindowManager.getBrowserWindow().goTab(comp);
    }

    public static void moveBrowserWindowToFront() {
        for (Frame frame : Frame.getFrames()) {
            if (frame.equals(BrowserWindowManager.getBrowserWindow())) continue;
            frame.toFront();
        }
    }

    static {
        browserWindow = null;
        stateHierarchy = null;
        platforms = new ArrayList<SwirldsPlatform>();
    }
}

