/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.topology;

import com.swirlds.base.time.Time;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.ConnectionManager;
import com.swirlds.platform.network.ConnectionTracker;
import com.swirlds.platform.network.PeerInfo;
import com.swirlds.platform.network.topology.ConnectionManagerFactory;
import com.swirlds.platform.network.topology.NetworkTopology;
import com.swirlds.platform.network.topology.StaticTopology;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;

public class DynamicConnectionManagers {
    private static final Logger logger = LogManager.getLogger(DynamicConnectionManagers.class);
    private final Configuration configuration;
    private final Time time;
    private final ConcurrentHashMap<NodeId, ConnectionManager> connectionManagers = new ConcurrentHashMap();
    private final NodeId selfId;
    private final ConnectionTracker connectionTracker;
    private final KeysAndCerts ownKeysAndCerts;
    private final ConnectionManagerFactory connectionManagerFactory;

    public DynamicConnectionManagers(@NonNull Configuration configuration, @NonNull Time time, @NonNull NodeId selfId, @NonNull List<PeerInfo> peers, @NonNull ConnectionTracker connectionTracker, @NonNull KeysAndCerts ownKeysAndCerts, @NonNull NetworkTopology topology, @NonNull ConnectionManagerFactory connectionManagerFactory) {
        this.configuration = Objects.requireNonNull(configuration);
        this.time = Objects.requireNonNull(time);
        this.selfId = Objects.requireNonNull(selfId);
        this.connectionTracker = Objects.requireNonNull(connectionTracker);
        this.ownKeysAndCerts = Objects.requireNonNull(ownKeysAndCerts);
        this.connectionManagerFactory = Objects.requireNonNull(connectionManagerFactory);
        for (PeerInfo peer : peers) {
            this.updateManager(topology, peer);
        }
    }

    public ConnectionManager getManager(NodeId id) {
        return this.connectionManagers.get(id);
    }

    public void newConnection(@NonNull Connection newConn) throws InterruptedException {
        ConnectionManager cs = this.connectionManagers.get(newConn.getOtherId());
        if (cs == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Unexpected new connection {}", (Object)newConn.getDescription());
            newConn.disconnect();
            return;
        }
        if (cs.isOutbound()) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Unexpected new connection, we should be connecting to them instead {}", (Object)newConn.getDescription());
            newConn.disconnect();
            return;
        }
        logger.debug(LogMarker.NETWORK.getMarker(), "{} accepted connection from {}", (Object)newConn.getSelfId(), (Object)newConn.getOtherId());
        try {
            cs.newConnection(newConn);
        }
        catch (InterruptedException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Interrupted while handling over new connection {}", (Object)newConn.getDescription(), (Object)e);
            newConn.disconnect();
            throw e;
        }
    }

    public void addRemovePeers(@NonNull List<PeerInfo> added, @NonNull List<PeerInfo> removed, @NonNull StaticTopology topology) {
        for (PeerInfo peerInfo : removed) {
            this.connectionManagers.remove(peerInfo.nodeId());
        }
        for (PeerInfo peerInfo : added) {
            this.updateManager(topology, peerInfo);
        }
    }

    private void updateManager(@NonNull NetworkTopology topology, @NonNull PeerInfo otherPeer) {
        if (topology.shouldConnectToMe(otherPeer.nodeId())) {
            this.connectionManagers.put(otherPeer.nodeId(), this.connectionManagerFactory.createInboundConnectionManager(otherPeer));
        } else if (topology.shouldConnectTo(otherPeer.nodeId())) {
            this.connectionManagers.put(otherPeer.nodeId(), this.connectionManagerFactory.createOutboundConnectionManager(this.configuration, this.time, this.selfId, otherPeer, this.connectionTracker, this.ownKeysAndCerts));
        } else {
            this.connectionManagers.remove(otherPeer.nodeId());
        }
    }
}

