/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.topology;

import com.swirlds.platform.network.PeerInfo;
import com.swirlds.platform.network.topology.NetworkTopology;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.hiero.consensus.model.node.NodeId;

public class StaticTopology
implements NetworkTopology {
    @NonNull
    private final Set<NodeId> nodeIds;
    private final NodeId selfId;

    public StaticTopology(@NonNull List<PeerInfo> peers, @NonNull NodeId selfId) {
        Objects.requireNonNull(peers);
        Objects.requireNonNull(selfId);
        this.nodeIds = peers.stream().map(PeerInfo::nodeId).collect(Collectors.toUnmodifiableSet());
        this.selfId = selfId;
    }

    @Override
    public Set<NodeId> getNeighbors() {
        return this.nodeIds;
    }

    @Override
    public boolean shouldConnectToMe(@NonNull NodeId nodeId) {
        return this.nodeIds.contains(nodeId) && nodeId.id() < this.selfId.id();
    }

    @Override
    public boolean shouldConnectTo(@NonNull NodeId nodeId) {
        return this.nodeIds.contains(nodeId) && nodeId.id() > this.selfId.id();
    }
}

