/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.nexus;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.config.StateConfig;
import com.swirlds.platform.state.nexus.LatestCompleteStateNexus;
import com.swirlds.platform.state.signed.ReservedSignedState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.hiero.consensus.metrics.RunningAverageMetric;
import org.hiero.consensus.model.hashgraph.EventWindow;

public class DefaultLatestCompleteStateNexus
implements LatestCompleteStateNexus {
    private static final RunningAverageMetric.Config AVG_ROUND_SUPERMAJORITY_CONFIG = new RunningAverageMetric.Config("platform", "roundSup").withDescription("latest round with state signed by a supermajority").withUnit("round");
    private final StateConfig stateConfig;
    private ReservedSignedState currentState;

    public DefaultLatestCompleteStateNexus(@NonNull PlatformContext platformContext) {
        this.stateConfig = (StateConfig)platformContext.getConfiguration().getConfigData(StateConfig.class);
        Metrics metrics = platformContext.getMetrics();
        RunningAverageMetric avgRoundSupermajority = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_ROUND_SUPERMAJORITY_CONFIG);
        metrics.addUpdater(() -> avgRoundSupermajority.update((double)this.getRound()));
    }

    @Override
    public synchronized void setState(@Nullable ReservedSignedState reservedSignedState) {
        if (this.currentState != null) {
            this.currentState.close();
        }
        this.currentState = reservedSignedState;
    }

    @Override
    public synchronized void setStateIfNewer(@NonNull ReservedSignedState reservedSignedState) {
        if (reservedSignedState.isNotNull() && this.getRound() < reservedSignedState.get().getRound()) {
            this.setState(reservedSignedState);
        } else {
            reservedSignedState.close();
        }
    }

    @Override
    public synchronized void updateEventWindow(@NonNull EventWindow eventWindow) {
        long earliestPermittedRound = eventWindow.latestConsensusRound() - (long)this.stateConfig.roundsToKeepForSigning() + 1L;
        if (this.getRound() < earliestPermittedRound) {
            this.clear();
        }
    }

    @Override
    @Nullable
    public synchronized ReservedSignedState getState(@NonNull String reason) {
        if (this.currentState == null) {
            return null;
        }
        return this.currentState.tryGetAndReserve(reason);
    }

    @Override
    public synchronized long getRound() {
        if (this.currentState == null) {
            return -1L;
        }
        return this.currentState.get().getRound();
    }
}

