/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.route.internal;

import com.swirlds.common.merkle.exceptions.MerkleRouteException;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.merkle.route.internal.AbstractMerkleRoute;
import com.swirlds.common.merkle.route.internal.BinaryMerkleRouteIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class BinaryMerkleRoute
extends AbstractMerkleRoute {
    private static final int CAPACITY_PER_INT = 30;
    private static final int LOWEST_ORDER_BIT_MASK = 1;
    private static final int ALL_ONES_MASK = -1;
    private static final int NEW_BINARY_DATA_INT = Integer.MIN_VALUE;
    private static final int[] emptyData = new int[0];
    private int[] data;

    public BinaryMerkleRoute() {
        this.data = emptyData;
    }

    private BinaryMerkleRoute(BinaryMerkleRoute baseRoute, int step) {
        this.data = BinaryMerkleRoute.copyAndExpandIfNeeded(baseRoute.data, step);
        BinaryMerkleRoute.addStepToRouteData(this.data, this.data.length - 1, step);
    }

    private BinaryMerkleRoute(BinaryMerkleRoute baseRoute, List<Integer> steps) {
        int expansion = BinaryMerkleRoute.getExpansionRequiredToHoldSteps(baseRoute.data, steps);
        this.data = Arrays.copyOf(baseRoute.data, baseRoute.data.length + expansion);
        int index = baseRoute.data.length == 0 ? 0 : baseRoute.data.length - 1;
        BinaryMerkleRoute.addStepsToRouteData(this.data, index, steps.iterator());
    }

    private BinaryMerkleRoute(BinaryMerkleRoute baseRoute, int[] steps) {
        int expansion = BinaryMerkleRoute.getExpansionRequiredToHoldSteps(baseRoute.data, steps);
        this.data = Arrays.copyOf(baseRoute.data, baseRoute.data.length + expansion);
        Iterable it = () -> Arrays.stream(steps).iterator();
        int index = baseRoute.data.length == 0 ? 0 : baseRoute.data.length - 1;
        BinaryMerkleRoute.addStepsToRouteData(this.data, index, it.iterator());
    }

    @Override
    public int size() {
        int length = 0;
        for (int datum : this.data) {
            if (datum > 0) {
                ++length;
                continue;
            }
            if (datum >= 0) continue;
            length += BinaryMerkleRoute.getNumberOfStepsInInt(datum);
        }
        return length;
    }

    @Override
    public boolean isEmpty() {
        return this.data.length == 0;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new BinaryMerkleRouteIterator(this.data);
    }

    @Override
    public MerkleRoute extendRoute(int step) {
        return new BinaryMerkleRoute(this, step);
    }

    @Override
    public MerkleRoute extendRoute(List<Integer> steps) {
        if (steps == null || steps.isEmpty()) {
            return this;
        }
        return new BinaryMerkleRoute(this, steps);
    }

    @Override
    public MerkleRoute extendRoute(int ... steps) {
        if (steps == null || steps.length == 0) {
            return this;
        }
        return new BinaryMerkleRoute(this, steps);
    }

    @Override
    public MerkleRoute getParent() {
        if (this.data.length == 0) {
            throw new NoSuchElementException("Cannot get parent of root");
        }
        ArrayList<Integer> steps = new ArrayList<Integer>();
        this.iterator().forEachRemaining(steps::add);
        steps.remove(steps.size() - 1);
        return new BinaryMerkleRoute().extendRoute(steps);
    }

    @Override
    public int getStep(int index) {
        int normalizedIndex;
        int n = normalizedIndex = index >= 0 ? index : this.size() + index;
        if (normalizedIndex < 0) {
            throw new IndexOutOfBoundsException("index " + index + " is out of bounds");
        }
        Iterator<Integer> iterator = this.iterator();
        int ret = -1;
        for (int i = 0; i <= normalizedIndex; ++i) {
            if (!iterator.hasNext()) {
                throw new IndexOutOfBoundsException("index " + index + " is out of bounds");
            }
            ret = iterator.next();
        }
        return ret;
    }

    public static int getBitAtIndex(int data, int index) {
        if (index < 0 || index >= 32) {
            throw new IndexOutOfBoundsException();
        }
        int mask = 1 << 32 - index - 1;
        return (mask & data) == 0 ? 0 : 1;
    }

    private static int setBitAtIndex(int data, int index, int value) {
        if (index < 0 || index >= 32) {
            throw new IndexOutOfBoundsException();
        }
        int mask = 1 << 32 - index - 1;
        if (value == 0) {
            mask = 0xFFFFFFFF ^ mask;
            return data & mask;
        }
        if (value == 1) {
            return data | mask;
        }
        throw new IllegalArgumentException("A bit may only hold a 0 or a 1");
    }

    private static int[] copyAndExpandIfNeeded(int[] routeData, int step) {
        if (BinaryMerkleRoute.hasCapacityForStep(routeData, step)) {
            return Arrays.copyOf(routeData, routeData.length);
        }
        return Arrays.copyOf(routeData, routeData.length + 1);
    }

    private static int getExpansionRequiredToHoldSteps(int[] routeData, int[] steps) {
        Iterable it = () -> Arrays.stream(steps).iterator();
        return BinaryMerkleRoute.getExpansionRequiredToHoldSteps(routeData, it.iterator());
    }

    private static int getExpansionRequiredToHoldSteps(int[] routeData, List<Integer> steps) {
        return BinaryMerkleRoute.getExpansionRequiredToHoldSteps(routeData, steps.iterator());
    }

    private static int getExpansionRequiredToHoldSteps(int[] routeData, Iterator<Integer> steps) {
        int expansionCount = 0;
        int availableBinaryCapacity = routeData.length == 0 ? 0 : BinaryMerkleRoute.getRemainingCapacityInInt(routeData[routeData.length - 1]);
        while (steps.hasNext()) {
            int step = steps.next();
            if (availableBinaryCapacity == 0 || step > 1 && availableBinaryCapacity < 30) {
                ++expansionCount;
                availableBinaryCapacity = 30;
            }
            if (step <= 1) {
                --availableBinaryCapacity;
                continue;
            }
            availableBinaryCapacity = 0;
        }
        return expansionCount;
    }

    private static int getRemainingCapacityInInt(int intData) {
        if (intData == 0 || intData == Integer.MIN_VALUE) {
            return 30;
        }
        int capacity = 0;
        boolean mask = true;
        while ((intData & 1) == 0) {
            ++capacity;
            intData >>= 1;
        }
        return capacity;
    }

    private static boolean hasCapacityForStep(int[] routeData, int step) {
        if (routeData.length == 0) {
            return false;
        }
        int lastIntInData = routeData[routeData.length - 1];
        if (step > 1) {
            return lastIntInData == 0;
        }
        if (lastIntInData > 0) {
            return false;
        }
        return (lastIntInData & 1) == 0;
    }

    private static void addBinaryStepToRouteData(int[] routeData, int index, int step) {
        int datum = routeData[index];
        if (datum == 0) {
            datum = Integer.MIN_VALUE;
        }
        int bitIndex = 30 - BinaryMerkleRoute.getRemainingCapacityInInt(datum) + 1;
        datum = BinaryMerkleRoute.setBitAtIndex(datum, bitIndex, step);
        routeData[index] = datum = BinaryMerkleRoute.setBitAtIndex(datum, bitIndex + 1, 1);
    }

    private static void addNaryStepToRouteData(int[] routeData, int index, int step) {
        routeData[index] = step;
    }

    private static void addStepToRouteData(int[] route, int index, int step) {
        if (step < 0) {
            throw new MerkleRouteException("Binary route steps can not be negative.");
        }
        if (step < 2) {
            BinaryMerkleRoute.addBinaryStepToRouteData(route, index, step);
        } else {
            BinaryMerkleRoute.addNaryStepToRouteData(route, index, step);
        }
    }

    private static void addStepsToRouteData(int[] route, int initialIndex, Iterator<Integer> steps) {
        int availableBinaryCapacity = BinaryMerkleRoute.getRemainingCapacityInInt(route[initialIndex]);
        int index = initialIndex;
        while (steps.hasNext()) {
            int step = steps.next();
            if (availableBinaryCapacity == 0 || step > 1 && availableBinaryCapacity < 30) {
                ++index;
                availableBinaryCapacity = 30;
            }
            if (step <= 1) {
                BinaryMerkleRoute.addBinaryStepToRouteData(route, index, step);
                --availableBinaryCapacity;
                continue;
            }
            BinaryMerkleRoute.addNaryStepToRouteData(route, index, step);
            availableBinaryCapacity = 0;
        }
    }

    public static int getNumberOfStepsInInt(int data) {
        return 30 - BinaryMerkleRoute.getRemainingCapacityInInt(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryMerkleRoute that = (BinaryMerkleRoute)o;
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }
}

