/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.InvalidOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class ReturnDataLoadOperation
extends AbstractOperation {
    public ReturnDataLoadOperation(GasCalculator gasCalculator) {
        super(247, "RETURNDATALOAD", 3, 0, gasCalculator);
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        Bytes returnData;
        int retunDataSize;
        Code code = frame.getCode();
        if (code.getEofVersion() == 0) {
            return InvalidOperation.INVALID_RESULT;
        }
        int offset = Words.clampedToInt(frame.popStackItem());
        Object value = offset > (retunDataSize = (returnData = frame.getReturnData()).size()) ? Bytes.EMPTY : (offset + 32 >= returnData.size() ? Bytes32.rightPad((Bytes)returnData.slice(offset)) : returnData.slice(offset, 32));
        frame.pushStackItem((Bytes)value);
        return new Operation.OperationResult(3L, null);
    }
}

