/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.defaultkycstatus;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.defaultkycstatus.DefaultKycStatusCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DefaultKycStatusTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod DEFAULT_KYC_STATUS = SystemContractMethod.declare("getTokenDefaultKycStatus(address)", "(int32,bool)").withModifier(SystemContractMethod.Modifier.VIEW).withCategory(SystemContractMethod.Category.TOKEN_QUERY);

    @Inject
    public DefaultKycStatusTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(DEFAULT_KYC_STATUS);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        return attempt.isMethod(DEFAULT_KYC_STATUS);
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        Tuple args = DEFAULT_KYC_STATUS.decodeCall(attempt.input().toArrayUnsafe());
        Token token = attempt.linkedToken(ConversionUtils.fromHeadlongAddress((Address)args.get(0)));
        return new DefaultKycStatusCall(attempt.systemContractGasCalculator(), attempt.enhancement(), attempt.isStaticCall(), token);
    }
}

