/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.calculator;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.token.TokenAirdropTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.token.impl.calculator.CryptoTransferFeeCalculator;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.TokensConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.support.fees.FeeSchedule;

public class TokenAirdropFeeCalculator
extends CryptoTransferFeeCalculator {
    @Override
    public void accumulateServiceFee(@NonNull TransactionBody txnBody, @Nullable FeeContext feeContext, @NonNull FeeResult feeResult, @NonNull FeeSchedule feeSchedule) {
        if (feeContext != null) {
            TokensConfig tokenConfig = (TokensConfig)feeContext.configuration().getConfigData(TokensConfig.class);
            HandleException.validateTrue((boolean)tokenConfig.airdropsEnabled(), (ResponseCodeEnum)ResponseCodeEnum.NOT_SUPPORTED);
        }
        TokenAirdropTransactionBody op = txnBody.tokenAirdropOrThrow();
        CryptoTransferTransactionBody cryptoTransferBody = CryptoTransferTransactionBody.newBuilder().tokenTransfers(op.tokenTransfers()).build();
        TransactionBody syntheticCryptoTransfer = TransactionBody.newBuilder().cryptoTransfer(cryptoTransferBody).transactionID(txnBody.transactionID()).build();
        super.accumulateServiceFee(syntheticCryptoTransfer, feeContext, feeResult, feeSchedule);
    }

    @Override
    public TransactionBody.DataOneOfType getTransactionType() {
        return TransactionBody.DataOneOfType.TOKEN_AIRDROP;
    }
}

