/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pcli;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.component.framework.model.WiringModel;
import com.swirlds.component.framework.model.WiringModelBuilder;
import com.swirlds.component.framework.model.diagram.ModelEdgeSubstitution;
import com.swirlds.component.framework.model.diagram.ModelGroup;
import com.swirlds.component.framework.model.diagram.ModelManualLink;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.builder.ApplicationCallbacks;
import com.swirlds.platform.builder.ConsensusModuleBuilder;
import com.swirlds.platform.builder.ExecutionLayer;
import com.swirlds.platform.config.DefaultConfiguration;
import com.swirlds.platform.util.VirtualTerminal;
import com.swirlds.platform.wiring.PlatformComponents;
import com.swirlds.platform.wiring.PlatformWiring;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.hiero.consensus.event.creator.EventCreatorModule;
import org.hiero.consensus.event.intake.EventIntakeModule;
import org.hiero.consensus.hashgraph.HashgraphModule;
import org.hiero.consensus.pces.PcesModule;
import org.hiero.consensus.pcli.AbstractCommand;
import org.hiero.consensus.pcli.Pcli;
import org.hiero.consensus.pcli.SubcommandOf;
import org.hiero.consensus.pcli.utility.NoOpExecutionLayer;
import picocli.CommandLine;

@CommandLine.Command(name="diagram", mixinStandardHelpOptions=true, description={"Generate a mermaid style diagram of platform wiring. Requires mermaid CLI to be installed."})
@SubcommandOf(value=Pcli.class)
public final class DiagramCommand
extends AbstractCommand {
    private List<String> groupStrings = List.of();
    private Set<String> collapsedGroups = Set.of();
    private List<String> substitutionStrings = List.of();
    private List<String> manualLinks = List.of();
    private Path outputFilePath = Path.of("wiring-diagram.svg", new String[0]);
    private boolean verbose = false;
    private boolean lessMystery = false;

    private DiagramCommand() {
    }

    @CommandLine.Option(names={"-g", "--group"}, description={"Specify an un-collapsed grouping. Format is 'GROUP_NAME:COMPONENT_NAME[,COMPONENT_NAME]*'."})
    private void setGroupStrings(@NonNull List<String> groupStrings) {
        this.groupStrings = groupStrings;
    }

    @CommandLine.Option(names={"-c", "--collapse"}, description={"Specify the name of a group that should be collapsed."})
    private void setCollapsedGroups(@NonNull Set<String> collapsedGroups) {
        this.collapsedGroups = collapsedGroups;
    }

    @CommandLine.Option(names={"-s", "--substitute"}, description={"Substitute a type of edge with a symbol. Useful for spammy edges. Format: SOURCE_COMPONENT:EDGE_DESCRIPTION:SYMBOL"})
    private void setCollapsedGroups(@NonNull List<String> substitutionStrings) {
        this.substitutionStrings = substitutionStrings;
    }

    @CommandLine.Option(names={"-l", "--link"}, description={"Manually link two components in the diagram. Format: SOURCE_COMPONENT:EDGE_LABEL:TARGET_COMPONENT"})
    private void setManualLinks(@NonNull List<String> manualLinks) {
        this.manualLinks = manualLinks;
    }

    @CommandLine.Option(names={"-o", "--output"}, description={"Specify the path to the output file. Defaults to 'wiring-diagram.svg'."})
    private void setOutputFile(@NonNull String outputFilePath) {
        this.outputFilePath = Path.of(outputFilePath, new String[0]).normalize();
    }

    @CommandLine.Option(names={"-v", "--verbose"}, description={"Print the diagram to the console."})
    private void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @CommandLine.Option(names={"-m", "--less-mystery"}, description={"Do not hide mystery edges. May create a noisy diagram if there are a lot of mystery edges."})
    private void setLessMystery(boolean lessMystery) {
        this.lessMystery = lessMystery;
    }

    @Override
    public Integer call() throws IOException {
        Configuration configuration = DefaultConfiguration.buildBasicConfiguration((ConfigurationBuilder)ConfigurationBuilder.create());
        PlatformContext platformContext = PlatformContext.create((Configuration)configuration);
        WiringModel model = WiringModelBuilder.create((Metrics)platformContext.getMetrics(), (Time)platformContext.getTime()).build();
        EventCreatorModule eventCreatorModule = ConsensusModuleBuilder.createNoOpEventCreatorModule((WiringModel)model, (Configuration)configuration);
        EventIntakeModule eventIntakeModule = ConsensusModuleBuilder.createNoOpEventIntakeModule((WiringModel)model, (Configuration)configuration);
        PcesModule pcesModule = ConsensusModuleBuilder.createNoOpPcesModule((WiringModel)model, (Configuration)configuration);
        HashgraphModule hashgraphModule = ConsensusModuleBuilder.createNoOpHashgraphModule((WiringModel)model, (Configuration)configuration);
        PlatformComponents platformComponents = PlatformComponents.create((PlatformContext)platformContext, (WiringModel)model, (EventCreatorModule)eventCreatorModule, (EventIntakeModule)eventIntakeModule, (PcesModule)pcesModule, (HashgraphModule)hashgraphModule);
        ApplicationCallbacks callbacks = new ApplicationCallbacks(e -> {}, s -> {}, e -> {});
        PlatformWiring.wire((PlatformContext)platformContext, (ExecutionLayer)new NoOpExecutionLayer(), (PlatformComponents)platformComponents, (ApplicationCallbacks)callbacks);
        String diagramString = model.generateWiringDiagram(this.parseGroups(), this.parseSubstitutions(), this.parseManualLinks(), !this.lessMystery);
        VirtualTerminal terminal = new VirtualTerminal().setProgressIndicatorEnabled(false).setThrowOnError(true).setPrintStdout(true).setPrintStderr(true);
        Path temporaryMermaidFile = Path.of("platformWiring.mmd", new String[0]);
        if (Files.exists(temporaryMermaidFile, new LinkOption[0])) {
            Files.delete(temporaryMermaidFile);
        }
        Files.createFile(temporaryMermaidFile, new FileAttribute[0]);
        Files.writeString(temporaryMermaidFile, (CharSequence)diagramString, new OpenOption[0]);
        terminal.run(new String[]{"mmdc", "-i", temporaryMermaidFile.toString(), "-o", this.outputFilePath.toString(), "--backgroundColor", "555555"});
        Files.delete(temporaryMermaidFile);
        if (this.verbose) {
            System.out.println(diagramString);
        }
        return 0;
    }

    @NonNull
    private List<ModelGroup> parseGroups() {
        ArrayList<ModelGroup> groups = new ArrayList<ModelGroup>();
        for (String group : this.groupStrings) {
            String[] parts = group.split(":");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Invalid group string: " + group);
            }
            String groupName = parts[0];
            String[] elements = parts[1].split(",");
            groups.add(new ModelGroup(groupName, Set.of(elements), this.collapsedGroups.contains(groupName)));
        }
        return groups;
    }

    @NonNull
    private List<ModelEdgeSubstitution> parseSubstitutions() {
        ArrayList<ModelEdgeSubstitution> substitutions = new ArrayList<ModelEdgeSubstitution>();
        for (String substitutionString : this.substitutionStrings) {
            String[] parts = substitutionString.split(":");
            if (parts.length != 3) {
                throw new IllegalArgumentException("Invalid substitution string: " + substitutionString);
            }
            String sourceComponent = parts[0];
            String edgeDescription = parts[1];
            String symbol = parts[2];
            substitutions.add(new ModelEdgeSubstitution(sourceComponent, edgeDescription, symbol));
        }
        return substitutions;
    }

    @NonNull
    private List<ModelManualLink> parseManualLinks() {
        ArrayList<ModelManualLink> links = new ArrayList<ModelManualLink>();
        for (String linkString : this.manualLinks) {
            String[] parts = linkString.split(":");
            if (parts.length != 3) {
                throw new IllegalArgumentException("Invalid link string: " + linkString);
            }
            String sourceComponent = parts[0];
            String edgeLabel = parts[1];
            String targetComponent = parts[2];
            links.add(new ModelManualLink(sourceComponent, edgeLabel, targetComponent));
        }
        return links;
    }
}

