/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.crypto.engine;

import com.sun.jna.ptr.PointerByReference;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.utility.CommonUtils;
import org.hyperledger.besu.nativelib.secp256k1.LibSecp256k1;

public class EcdsaSecp256k1Verifier {
    public static final int ECDSA_KECCAK_256_SIZE = 32;
    public static final int ECDSA_UNCOMPRESSED_KEY_SIZE = 64;
    public static final int ECDSA_SIGNATURE_SIZE = 64;
    private static final int ECDSA_UNCOMPRESSED_KEY_SIZE_WITH_HEADER_BYTE = 65;
    private static final ThreadLocal<ThreadLocalCache> CACHE = ThreadLocal.withInitial(ThreadLocalCache::new);
    private static final Logger logger = LogManager.getLogger(EcdsaSecp256k1Verifier.class);

    public boolean verify(@NonNull byte[] rawSig, @NonNull byte[] msgHash, @NonNull byte[] pubKey) {
        if (msgHash.length != 32) {
            logger.warn(LogMarker.TESTING_EXCEPTIONS.getMarker(), () -> "Message is not Keccak256 hash size 32 bytes [ msg = %s ]".formatted(CommonUtils.hex((byte[])msgHash)));
            return false;
        }
        if (pubKey.length != 64) {
            logger.warn(LogMarker.TESTING_EXCEPTIONS.getMarker(), () -> "Public key is not %d bytes [ publicKey = %s ]".formatted(64, CommonUtils.hex((byte[])pubKey)));
            return false;
        }
        if (rawSig.length != 64) {
            logger.warn(LogMarker.TESTING_EXCEPTIONS.getMarker(), () -> "Signature is not %d bytes [ rawSig = %s ]".formatted(64, CommonUtils.hex((byte[])rawSig)));
            return false;
        }
        ThreadLocalCache cache = CACHE.get();
        LibSecp256k1.secp256k1_ecdsa_signature nativeSignature = cache.signature;
        int signatureParseResult = LibSecp256k1.secp256k1_ecdsa_signature_parse_compact((PointerByReference)LibSecp256k1.CONTEXT, (LibSecp256k1.secp256k1_ecdsa_signature)nativeSignature, (byte[])rawSig);
        if (signatureParseResult != 1) {
            logger.warn(LogMarker.TESTING_EXCEPTIONS.getMarker(), () -> "Failed to parse signature [ publicKey = %s, rawSig = %s ]".formatted(CommonUtils.hex((byte[])pubKey), CommonUtils.hex((byte[])rawSig)));
            return false;
        }
        LibSecp256k1.secp256k1_ecdsa_signature_normalize((PointerByReference)LibSecp256k1.CONTEXT, (LibSecp256k1.secp256k1_ecdsa_signature)nativeSignature, (LibSecp256k1.secp256k1_ecdsa_signature)nativeSignature);
        byte[] publicKeyInput = cache.uncompressedPublicKeyInput;
        System.arraycopy(pubKey, 0, publicKeyInput, 1, 64);
        LibSecp256k1.secp256k1_pubkey nativePublicKey = cache.publicKey;
        int keyParseResult = LibSecp256k1.secp256k1_ec_pubkey_parse((PointerByReference)LibSecp256k1.CONTEXT, (LibSecp256k1.secp256k1_pubkey)nativePublicKey, (byte[])publicKeyInput, (long)publicKeyInput.length);
        if (keyParseResult != 1) {
            logger.warn(LogMarker.TESTING_EXCEPTIONS.getMarker(), () -> "Failed to parse public key [ publicKey = %s, rawSig = %s ]".formatted(CommonUtils.hex((byte[])pubKey), CommonUtils.hex((byte[])rawSig)));
            return false;
        }
        int result = LibSecp256k1.secp256k1_ecdsa_verify((PointerByReference)LibSecp256k1.CONTEXT, (LibSecp256k1.secp256k1_ecdsa_signature)nativeSignature, (byte[])msgHash, (LibSecp256k1.secp256k1_pubkey)nativePublicKey);
        return result == 1;
    }

    private record ThreadLocalCache(LibSecp256k1.secp256k1_ecdsa_signature signature, LibSecp256k1.secp256k1_pubkey publicKey, byte[] uncompressedPublicKeyInput) {
        public ThreadLocalCache() {
            this(new LibSecp256k1.secp256k1_ecdsa_signature(), new LibSecp256k1.secp256k1_pubkey(), new byte[65]);
            this.uncompressedPublicKeyInput[0] = 4;
        }
    }
}

