/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.spi;

import com.swirlds.state.spi.KVChangeListener;
import com.swirlds.state.spi.ReadableKVStateBase;
import com.swirlds.state.spi.WritableKVState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public abstract class WritableKVStateBase<K, V>
extends ReadableKVStateBase<K, V>
implements WritableKVState<K, V> {
    private final Map<K, V> modifications;
    private final List<KVChangeListener<K, V>> listeners = new ArrayList<KVChangeListener<K, V>>();

    protected WritableKVStateBase(int stateId, String label) {
        this(stateId, label, new LinkedHashMap());
    }

    protected WritableKVStateBase(int stateId, @NonNull String label, @NonNull Map<K, V> modifications) {
        super(stateId, label);
        this.modifications = Objects.requireNonNull(modifications);
    }

    protected WritableKVStateBase(int stateId, @NonNull String label, @NonNull Map<K, V> modifications, @NonNull ConcurrentMap<K, V> readCache) {
        super(stateId, label, readCache);
        this.modifications = Objects.requireNonNull(modifications);
    }

    public void registerListener(@NonNull KVChangeListener<K, V> listener) {
        Objects.requireNonNull(listener);
        this.listeners.add(listener);
    }

    public void commit() {
        for (Map.Entry<K, V> entry : this.modifications.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                this.removeFromDataSource(key);
                this.listeners.forEach(listener -> listener.mapDeleteChange(key));
                continue;
            }
            this.putIntoDataSource(key, value);
            this.listeners.forEach(listener -> listener.mapUpdateChange(key, value));
        }
        this.reset();
    }

    @Override
    public final void reset() {
        super.reset();
        this.modifications.clear();
    }

    @Override
    @Nullable
    public final V get(@NonNull K key) {
        if (this.modifications.containsKey(key)) {
            return this.modifications.get(key);
        }
        return super.get(key);
    }

    @Override
    @Nullable
    public V getOriginalValue(@NonNull K key) {
        return super.get(key);
    }

    @Override
    public final void put(@NonNull K key, @NonNull V value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        this.modifications.put(key, value);
    }

    @Override
    public final void remove(@NonNull K key) {
        Objects.requireNonNull(key);
        this.modifications.put(key, null);
    }

    @Override
    @NonNull
    public Iterator<K> keys() {
        HashSet<K> removedKeys = new HashSet<K>();
        HashSet<K> maybeAddedKeys = new HashSet<K>();
        for (Map.Entry<K, V> mod : this.modifications.entrySet()) {
            K key = mod.getKey();
            V val = mod.getValue();
            if (val == null) {
                removedKeys.add(key);
                continue;
            }
            maybeAddedKeys.add(key);
        }
        Iterator backendItr = super.keys();
        return new KVStateKeyIterator(backendItr, removedKeys, maybeAddedKeys);
    }

    @Override
    @NonNull
    public final Set<K> modifiedKeys() {
        return this.modifications.keySet();
    }

    @Override
    @Deprecated
    public long size() {
        long sizeOfBackingMap = this.sizeOfDataSource();
        int numAdditions = 0;
        int numRemovals = 0;
        for (Map.Entry<K, V> mod : this.modifications.entrySet()) {
            boolean isRemovedInMod;
            boolean isPresentInBackingMap = this.readFromDataSource(mod.getKey()) != null;
            boolean bl = isRemovedInMod = mod.getValue() == null;
            if (isPresentInBackingMap && isRemovedInMod) {
                ++numRemovals;
                continue;
            }
            if (isPresentInBackingMap || isRemovedInMod) continue;
            ++numAdditions;
        }
        return sizeOfBackingMap + (long)numAdditions - (long)numRemovals;
    }

    protected abstract void putIntoDataSource(@NonNull K var1, @NonNull V var2);

    protected abstract void removeFromDataSource(@NonNull K var1);

    protected abstract long sizeOfDataSource();

    private static final class KVStateKeyIterator<K>
    implements Iterator<K> {
        private final Iterator<K> backendItr;
        private final Set<K> removedKeys;
        private final Set<K> maybeAddedKeys;
        private Iterator<K> addedItr;
        private K next;

        private KVStateKeyIterator(@NonNull Iterator<K> backendItr, @NonNull Set<K> removedKeys, @NonNull Set<K> maybeAddedKeys) {
            this.backendItr = backendItr;
            this.removedKeys = removedKeys;
            this.maybeAddedKeys = maybeAddedKeys;
        }

        @Override
        public boolean hasNext() {
            this.prepareNext();
            return this.next != null;
        }

        @Override
        public K next() {
            this.prepareNext();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            K ret = this.next;
            this.next = null;
            return ret;
        }

        private void prepareNext() {
            while (this.next == null) {
                if (this.backendItr.hasNext()) {
                    K candidate = this.backendItr.next();
                    this.maybeAddedKeys.remove(candidate);
                    if (this.removedKeys.contains(candidate)) continue;
                    this.next = candidate;
                    return;
                }
                if (this.addedItr == null) {
                    this.addedItr = this.maybeAddedKeys.iterator();
                }
                if (this.addedItr.hasNext()) {
                    this.next = this.addedItr.next();
                }
                return;
            }
        }
    }
}

