/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.hapi.fees;

import com.hedera.hapi.node.base.HederaFunctionality;
import java.util.HashSet;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.ExtraFeeDefinition;
import org.hiero.hapi.support.fees.ExtraFeeReference;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;
import org.hiero.hapi.support.fees.ServiceFeeSchedule;

public class FeeScheduleUtils {
    private static final Logger logger = LogManager.getLogger(FeeScheduleUtils.class);

    public static ExtraFeeDefinition makeExtraDef(Extra extra, long fee) {
        return ExtraFeeDefinition.newBuilder().name(extra).fee(fee).build();
    }

    public static ExtraFeeReference makeExtraIncluded(Extra extra, int included) {
        return ExtraFeeReference.DEFAULT.copyBuilder().name(extra).includedCount(included).build();
    }

    public static ServiceFeeDefinition makeServiceFee(HederaFunctionality name, long baseFee, ExtraFeeReference ... reference) {
        return ServiceFeeDefinition.DEFAULT.copyBuilder().name(name).baseFee(baseFee).extras(reference).build();
    }

    public static ServiceFeeSchedule makeService(String name, ServiceFeeDefinition ... services) {
        return ServiceFeeSchedule.DEFAULT.copyBuilder().name(name).schedule(services).build();
    }

    public static ExtraFeeDefinition lookupExtraFee(FeeSchedule feeSchedule, Extra ref) {
        for (ExtraFeeDefinition def : feeSchedule.extras()) {
            if (!def.name().equals((Object)ref)) continue;
            return def;
        }
        return null;
    }

    public static ServiceFeeDefinition lookupServiceFee(FeeSchedule feeSchedule, HederaFunctionality api) {
        for (ServiceFeeSchedule service : feeSchedule.services()) {
            for (ServiceFeeDefinition def : service.schedule()) {
                if (def.name() != api) continue;
                return def;
            }
        }
        return null;
    }

    public static boolean isValid(FeeSchedule feeSchedule) {
        Objects.requireNonNull(feeSchedule);
        if (feeSchedule.node() == null) {
            logger.error("Node fee is required in simple fee schedule");
            return false;
        }
        if (feeSchedule.network() == null) {
            logger.error("Network fee is required in simple fee schedule");
            return false;
        }
        if (feeSchedule.network().multiplier() < 1) {
            logger.error("Network fee multiplier must be greater than or equal to 1. Given {}", (Object)feeSchedule.network().multiplier());
            return false;
        }
        if (feeSchedule.services().isEmpty()) {
            logger.error("At least one service is required in simple fee schedule");
            return false;
        }
        HashSet<Extra> extraNames = new HashSet<Extra>();
        for (Object def : feeSchedule.extras()) {
            if (def.fee() <= 0L) {
                logger.error("Extra fee must be greater than 0 in simple fee schedule for {}, fee {}", (Object)def.name(), (Object)def.fee());
                return false;
            }
            if (extraNames.add(def.name())) continue;
            logger.error("Extra fee names must be unique in simple fee schedule for {}", (Object)def.name());
            return false;
        }
        HashSet<String> serviceNames = new HashSet<String>();
        for (ServiceFeeSchedule service : feeSchedule.services()) {
            if (!serviceNames.add(service.name())) {
                logger.error("Service names must be unique in simple fee schedule {}", (Object)service.name());
                return false;
            }
            if (service.schedule().isEmpty()) {
                logger.error("Service schedule cannot be empty in simple fee schedule {}", (Object)service.name());
                return false;
            }
            HashSet<HederaFunctionality> txNames = new HashSet<HederaFunctionality>();
            for (ServiceFeeDefinition def : service.schedule()) {
                if (!txNames.add(def.name())) {
                    logger.error("Transaction names must be unique within service in simple fee schedule {}", (Object)def.name());
                    return false;
                }
                if (def.baseFee() < 0L) {
                    logger.error("Base fee must be greater than 0 in simple fee schedule {}", (Object)def.name());
                    return false;
                }
                HashSet<Extra> refNames = new HashSet<Extra>();
                for (ExtraFeeReference ref : def.extras()) {
                    if (ref.includedCount() < 0) {
                        logger.error("Included count must be greater than or equal to 0 in simple fee schedule {}", (Object)ref.name());
                        return false;
                    }
                    if (!refNames.add(ref.name())) {
                        logger.error("Extra fee names must be unique within transaction in simple fee schedule {}", (Object)ref.name());
                        return false;
                    }
                    if (FeeScheduleUtils.lookupExtraFee(feeSchedule, ref.name()) != null) continue;
                    logger.error("Extra fee {} not found in simple fee schedule", (Object)ref.name());
                    return false;
                }
            }
        }
        if (feeSchedule.node().baseFee() < 0L) {
            logger.error("Node base fee must be greater than or equal to 0 in simple fee schedule. Given {}", (Object)feeSchedule.node().baseFee());
            return false;
        }
        HashSet<Extra> nodeRefNames = new HashSet<Extra>();
        for (ExtraFeeReference ref : feeSchedule.node().extras()) {
            if (ref.includedCount() < 0) {
                logger.error("Included count must be greater than or equal to 0 in simple fee schedule {}, included count {}", (Object)ref.name(), (Object)ref.includedCount());
                return false;
            }
            if (!nodeRefNames.add(ref.name())) {
                logger.error("Extra fee names must be unique within node fee in simple fee schedule {}", (Object)ref.name());
                return false;
            }
            if (FeeScheduleUtils.lookupExtraFee(feeSchedule, ref.name()) != null) continue;
            logger.error("Extra fee {} not found in simple fee schedule", (Object)ref.name());
            return false;
        }
        return true;
    }
}

