/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl;

import com.hedera.node.app.blocks.StreamingTreeHasher;
import com.hedera.node.app.hapi.utils.CommonUtils;
import com.hedera.node.app.records.impl.BlockRecordInfoUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.MessageDigest;

public class BlockImplUtils {
    private BlockImplUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static Bytes appendHash(@NonNull Bytes hash, @NonNull Bytes hashes, int maxHashes) {
        byte[] newBytes;
        int limit = BlockRecordInfoUtils.HASH_SIZE * maxHashes;
        byte[] bytes = hashes.toByteArray();
        if (bytes.length < limit) {
            newBytes = new byte[bytes.length + BlockRecordInfoUtils.HASH_SIZE];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
            hash.getBytes(0L, newBytes, newBytes.length - BlockRecordInfoUtils.HASH_SIZE, BlockRecordInfoUtils.HASH_SIZE);
        } else {
            newBytes = bytes;
            System.arraycopy(newBytes, BlockRecordInfoUtils.HASH_SIZE, newBytes, 0, newBytes.length - BlockRecordInfoUtils.HASH_SIZE);
            hash.getBytes(0L, newBytes, newBytes.length - BlockRecordInfoUtils.HASH_SIZE, BlockRecordInfoUtils.HASH_SIZE);
        }
        return Bytes.wrap((byte[])newBytes);
    }

    public static Bytes combine(@NonNull Bytes leftHash, @NonNull Bytes rightHash) {
        return Bytes.wrap((byte[])BlockImplUtils.combine(leftHash.toByteArray(), rightHash.toByteArray()));
    }

    public static byte[] combine(@NonNull byte[] leftHash, @NonNull byte[] rightHash) {
        return CommonUtils.sha384HashOfAll((byte[][])new byte[][]{leftHash, rightHash}).toByteArray();
    }

    public static byte[] hashLeaf(@NonNull byte[] leafData) {
        return CommonUtils.sha384HashOf((byte[][])new byte[][]{StreamingTreeHasher.LEAF_PREFIX, leafData});
    }

    public static Bytes hashLeaf(@NonNull Bytes leafData) {
        return CommonUtils.sha384HashOfAll((Bytes[])new Bytes[]{Bytes.wrap((byte[])StreamingTreeHasher.LEAF_PREFIX), leafData});
    }

    public static Bytes hashLeaf(@NonNull MessageDigest digest, @NonNull Bytes leafData) {
        return CommonUtils.hashOfAll((MessageDigest)digest, (Bytes[])new Bytes[]{Bytes.wrap((byte[])StreamingTreeHasher.LEAF_PREFIX), leafData});
    }

    public static Bytes hashInternalNodeSingleChild(@NonNull Bytes hash) {
        return CommonUtils.sha384HashOfAll((byte[][])new byte[][]{StreamingTreeHasher.SINGLE_CHILD_INTERNAL_NODE_PREFIX, hash.toByteArray()});
    }

    public static Bytes hashInternalNode(@NonNull Bytes leftHash, @NonNull byte[] rightHash) {
        return CommonUtils.sha384HashOf((Bytes)StreamingTreeHasher.INTERNAL_NODE_PREFIX_BYTES, (Bytes)leftHash, (byte[])rightHash);
    }

    public static Bytes hashInternalNode(@NonNull Bytes leftHash, @NonNull Bytes rightHash) {
        return CommonUtils.sha384HashOfAll((Bytes[])new Bytes[]{StreamingTreeHasher.INTERNAL_NODE_PREFIX_BYTES, leftHash, rightHash});
    }

    public static byte[] hashInternalNode(@NonNull byte[] leftHash, @NonNull byte[] rightHash) {
        return CommonUtils.sha384HashOfAll((byte[][])new byte[][]{StreamingTreeHasher.INTERNAL_NODE_PREFIX, leftHash, rightHash}).toByteArray();
    }

    public static byte[] hashInternalNode(@NonNull MessageDigest digest, @NonNull byte[] leftHash, @NonNull byte[] rightHash) {
        return CommonUtils.hashOfAll((MessageDigest)digest, (byte[][])new byte[][]{StreamingTreeHasher.INTERNAL_NODE_PREFIX, leftHash, rightHash});
    }
}

