/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.context;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.io.filesystem.FileSystemManager;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hiero.base.concurrent.ExecutorFactory;
import org.hiero.consensus.io.RecycleBin;

public final class DefaultPlatformContext
implements PlatformContext {
    private final Configuration configuration;
    private final Metrics metrics;
    private final Time time;
    private final ExecutorFactory executorFactory;
    private final FileSystemManager fileSystemManager;
    private final RecycleBin recycleBin;

    public DefaultPlatformContext(@NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time, @NonNull ExecutorFactory executorFactory, @NonNull FileSystemManager fileSystemManager, @NonNull RecycleBin recycleBin) {
        this.configuration = Objects.requireNonNull(configuration, "configuration must not be null");
        this.metrics = Objects.requireNonNull(metrics, "metrics must not be null");
        this.time = Objects.requireNonNull(time, "time must not be null");
        this.executorFactory = Objects.requireNonNull(executorFactory, "executorFactory must not be null");
        this.fileSystemManager = Objects.requireNonNull(fileSystemManager, "fileSystemManager must not be null");
        this.recycleBin = Objects.requireNonNull(recycleBin, "recycleBin must not be null");
    }

    @Override
    @NonNull
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    @NonNull
    public Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    @NonNull
    public Time getTime() {
        return this.time;
    }

    @Override
    @NonNull
    public FileSystemManager getFileSystemManager() {
        return this.fileSystemManager;
    }

    @Override
    @NonNull
    public ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    @Override
    @NonNull
    public RecycleBin getRecycleBin() {
        return this.recycleBin;
    }
}

