/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.preconsensus;

import com.swirlds.base.formatting.StringFormattingUtils;
import com.swirlds.base.formatting.UnitFormatter;
import com.swirlds.base.time.Time;
import com.swirlds.base.units.TimeUnit;
import com.swirlds.base.units.Unit;
import com.swirlds.component.framework.wires.input.NoInput;
import com.swirlds.component.framework.wires.output.StandardOutputWire;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.state.signed.ReservedSignedState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.concurrent.utility.throttle.RateLimiter;
import org.hiero.consensus.io.IOIterator;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.pces.config.PcesConfig;

public class PcesReplayer {
    private static final Logger logger = LogManager.getLogger(PcesReplayer.class);
    private final Time time;
    private final StandardOutputWire<PlatformEvent> eventOutputWire;
    private final Runnable flushIntake;
    private final Runnable flushTransactionHandling;
    private final Supplier<ReservedSignedState> latestImmutableState;
    private final Supplier<Boolean> isSystemHealthy;
    private final PcesConfig config;

    public PcesReplayer(@NonNull Configuration configuration, @NonNull Time time, @NonNull StandardOutputWire<PlatformEvent> eventOutputWire, @NonNull Runnable flushIntake, @NonNull Runnable flushTransactionHandling, @NonNull Supplier<ReservedSignedState> latestImmutableState, @NonNull Supplier<Boolean> isSystemHealthy) {
        this.time = Objects.requireNonNull(time);
        this.eventOutputWire = Objects.requireNonNull(eventOutputWire);
        this.flushIntake = Objects.requireNonNull(flushIntake);
        this.flushTransactionHandling = Objects.requireNonNull(flushTransactionHandling);
        this.latestImmutableState = Objects.requireNonNull(latestImmutableState);
        this.isSystemHealthy = Objects.requireNonNull(isSystemHealthy);
        this.config = (PcesConfig)configuration.getConfigData(PcesConfig.class);
    }

    private void logReplayInfo(@Nullable Instant timestampBeforeReplay, long roundBeforeReplay, long eventCount, long transactionCount, @NonNull Duration elapsedTime, long maxBirthRound) {
        try (ReservedSignedState stateAfterReplay = this.latestImmutableState.get();){
            if (stateAfterReplay == null || stateAfterReplay.isNull()) {
                logger.info(LogMarker.STARTUP.getMarker(), "Replayed {} preconsensus events. No rounds reached consensus.", (Object)StringFormattingUtils.commaSeparatedNumber((long)eventCount));
                return;
            }
            long roundAfterReplay = stateAfterReplay.get().getRound();
            long elapsedRounds = roundAfterReplay - roundBeforeReplay;
            Instant timestampAfterReplay = stateAfterReplay.get().getConsensusTimestamp();
            Duration elapsedConsensusTime = timestampBeforeReplay != null ? Duration.between(timestampBeforeReplay, timestampAfterReplay) : null;
            logger.info(LogMarker.STARTUP.getMarker(), "Replayed {} preconsensus events with max birth round {}. These events contained {} transactions. {} rounds reached consensus spanning {} of consensus time. The latest round to reach consensus is round {}. Replay took {}.", (Object)StringFormattingUtils.commaSeparatedNumber((long)eventCount), (Object)StringFormattingUtils.commaSeparatedNumber((long)maxBirthRound), (Object)StringFormattingUtils.commaSeparatedNumber((long)transactionCount), (Object)StringFormattingUtils.commaSeparatedNumber((long)elapsedRounds), (Object)(elapsedConsensusTime != null ? new UnitFormatter(elapsedConsensusTime.toMillis(), (Unit)TimeUnit.UNIT_MILLISECONDS).setAbbreviate(false).render() : "n/a"), (Object)StringFormattingUtils.commaSeparatedNumber((long)roundAfterReplay), (Object)new UnitFormatter(elapsedTime.toMillis(), (Unit)TimeUnit.UNIT_MILLISECONDS).setAbbreviate(false).render());
        }
    }

    @NonNull
    public NoInput replayPces(@NonNull IOIterator<PlatformEvent> eventIterator) {
        long roundBeforeReplay;
        Instant timestampBeforeReplay;
        Objects.requireNonNull(eventIterator);
        Instant start = this.time.now();
        try (ReservedSignedState startState = this.latestImmutableState.get();){
            if (startState == null || startState.isNull()) {
                timestampBeforeReplay = null;
                roundBeforeReplay = -1L;
            } else {
                timestampBeforeReplay = startState.get().getConsensusTimestamp();
                roundBeforeReplay = startState.get().getRound();
            }
        }
        RateLimiter rateLimiter = new RateLimiter(this.time, (double)this.config.maxEventReplayFrequency());
        int eventCount = 0;
        int transactionCount = 0;
        long maxBirthRound = -1L;
        try {
            while (eventIterator.hasNext()) {
                this.waitUntilHealthy();
                if (this.config.limitReplayFrequency() && !rateLimiter.requestAndTrigger()) continue;
                PlatformEvent event = (PlatformEvent)eventIterator.next();
                event.setTimeReceived(this.time.now());
                ++eventCount;
                transactionCount += event.getTransactionCount();
                maxBirthRound = Math.max(maxBirthRound, event.getBirthRound());
                this.eventOutputWire.forward((Object)event);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("error encountered while reading from the PCES", e);
        }
        this.flushIntake.run();
        this.flushTransactionHandling.run();
        Duration elapsedTime = Duration.between(start, this.time.now());
        this.logReplayInfo(timestampBeforeReplay, roundBeforeReplay, eventCount, transactionCount, elapsedTime, maxBirthRound);
        return NoInput.getInstance();
    }

    private void waitUntilHealthy() {
        while (!this.isSystemHealthy.get().booleanValue()) {
            try {
                java.util.concurrent.TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("interrupted while replaying PCES", e);
            }
        }
    }
}

