/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.service.schemas;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.hedera.hapi.platform.state.PlatformState;
import com.hedera.hapi.platform.state.SingletonType;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import com.swirlds.platform.state.PlatformStateModifier;
import com.swirlds.platform.state.service.WritablePlatformStateStore;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.spi.WritableSingletonState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hiero.consensus.config.BasicConfig;

public class V0540PlatformStateSchema
extends Schema<SemanticVersion> {
    private static final Function<Configuration, SemanticVersion> UNAVAILABLE_VERSION_FN = config -> {
        throw new IllegalStateException("No version information available");
    };
    public static final String PLATFORM_STATE_KEY = "PLATFORM_STATE";
    public static final int PLATFORM_STATE_STATE_ID = SingletonType.PLATFORMSTATESERVICE_I_PLATFORM_STATE.protoOrdinal();
    public static final String PLATFORM_STATE_STATE_LABEL = StateMetadata.computeLabel((String)"PlatformStateService", (String)"PLATFORM_STATE");
    public static final PlatformState UNINITIALIZED_PLATFORM_STATE = new PlatformState(null, 0, ConsensusSnapshot.DEFAULT, null, null, 0L, Bytes.EMPTY);
    private static final SemanticVersion VERSION = SemanticVersion.newBuilder().major(0).minor(54).patch(0).build();
    private final Function<Configuration, SemanticVersion> versionFn;

    public V0540PlatformStateSchema() {
        this(UNAVAILABLE_VERSION_FN);
    }

    public V0540PlatformStateSchema(@NonNull Function<Configuration, SemanticVersion> versionFn) {
        super((Object)VERSION, HapiUtils.SEMANTIC_VERSION_COMPARATOR);
        this.versionFn = Objects.requireNonNull(versionFn);
    }

    @NonNull
    public Set<StateDefinition> statesToCreate() {
        return Set.of(StateDefinition.singleton((int)PLATFORM_STATE_STATE_ID, (String)PLATFORM_STATE_KEY, (Codec)PlatformState.PROTOBUF));
    }

    public void migrate(@NonNull MigrationContext ctx) {
        WritableSingletonState stateSingleton = ctx.newStates().getSingleton(PLATFORM_STATE_STATE_ID);
        if (ctx.isGenesis()) {
            stateSingleton.put((Object)UNINITIALIZED_PLATFORM_STATE);
            WritablePlatformStateStore platformStateStore = new WritablePlatformStateStore(ctx.newStates());
            platformStateStore.bulkUpdate(this.genesisStateSpec(ctx));
        } else if (stateSingleton.get() == null) {
            stateSingleton.put((Object)UNINITIALIZED_PLATFORM_STATE);
        }
    }

    private Consumer<PlatformStateModifier> genesisStateSpec(@NonNull MigrationContext ctx) {
        return v -> {
            v.setCreationSoftwareVersion(this.versionFn.apply(ctx.appConfig()));
            v.setRound(0L);
            v.setLegacyRunningEventHash(null);
            v.setConsensusTimestamp(Instant.EPOCH);
            BasicConfig basicConfig = (BasicConfig)ctx.platformConfig().getConfigData(BasicConfig.class);
        };
    }
}

