/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.wiring;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.component.framework.transformers.AdvancedTransformation;
import com.swirlds.component.framework.transformers.WireFilter;
import com.swirlds.component.framework.wires.SolderType;
import com.swirlds.component.framework.wires.output.OutputWire;
import com.swirlds.platform.builder.ApplicationCallbacks;
import com.swirlds.platform.builder.ExecutionLayer;
import com.swirlds.platform.components.AppNotifier;
import com.swirlds.platform.components.EventWindowManager;
import com.swirlds.platform.components.SavedStateController;
import com.swirlds.platform.components.appcomm.LatestCompleteStateNotifier;
import com.swirlds.platform.event.branching.BranchDetector;
import com.swirlds.platform.event.branching.BranchReporter;
import com.swirlds.platform.event.stream.ConsensusEventStream;
import com.swirlds.platform.eventhandling.TransactionHandler;
import com.swirlds.platform.eventhandling.TransactionHandlerResult;
import com.swirlds.platform.eventhandling.TransactionPrehandler;
import com.swirlds.platform.state.hasher.StateHasher;
import com.swirlds.platform.state.hashlogger.HashLogger;
import com.swirlds.platform.state.iss.IssDetector;
import com.swirlds.platform.state.iss.IssHandler;
import com.swirlds.platform.state.nexus.LatestCompleteStateNexus;
import com.swirlds.platform.state.nexus.SignedStateNexus;
import com.swirlds.platform.state.signed.SignedStateSentinel;
import com.swirlds.platform.state.signed.StateGarbageCollector;
import com.swirlds.platform.state.signed.StateSignatureCollector;
import com.swirlds.platform.state.signer.StateSigner;
import com.swirlds.platform.state.snapshot.StateSnapshotManager;
import com.swirlds.platform.system.PlatformMonitor;
import com.swirlds.platform.system.state.notifications.StateHashedNotification;
import com.swirlds.platform.system.status.PlatformStatusConfig;
import com.swirlds.platform.wiring.PlatformComponents;
import com.swirlds.platform.wiring.PlatformSchedulersConfig;
import com.swirlds.platform.wiring.SignedStateReserver;
import com.swirlds.platform.wiring.StateWithHashComplexityReserver;
import com.swirlds.platform.wiring.StateWithHashComplexityToStateReserver;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hiero.consensus.model.hashgraph.ConsensusRound;

public class PlatformWiring {
    public static void wire(@NonNull PlatformContext platformContext, @NonNull ExecutionLayer execution, @NonNull PlatformComponents components, @NonNull ApplicationCallbacks callbacks) {
        Objects.requireNonNull(platformContext);
        Objects.requireNonNull(execution);
        Objects.requireNonNull(components);
        components.gossipWiring().getEventOutput().solderTo(components.eventIntakeModule().unhashedEventsInputWire());
        components.gossipWiring().getSyncProgressOutput().solderTo(components.eventCreatorModule().syncProgressInputWire());
        components.eventIntakeModule().validatedEventsOutputWire().solderTo(components.pcesModule().eventsToWriteInputWire());
        OutputWire writtenEventOutputWire = components.pcesModule().writtenEventsOutputWire();
        writtenEventOutputWire.solderTo(components.hashgraphModule().eventInputWire());
        writtenEventOutputWire.solderTo(components.gossipWiring().getEventInput(), SolderType.INJECT);
        writtenEventOutputWire.solderTo(components.eventCreatorModule().orderedEventInputWire());
        components.model().getHealthMonitorWire().solderTo(components.eventCreatorModule().healthStatusInputWire());
        components.model().getHealthMonitorWire().solderTo(components.gossipWiring().getSystemHealthInput());
        components.model().getHealthMonitorWire().solderTo("executionHealthInput", "healthyDuration", execution::reportUnhealthyDuration);
        components.eventIntakeModule().validatedEventsOutputWire().solderTo(components.branchDetectorWiring().getInputWire(BranchDetector::checkForBranches));
        components.branchDetectorWiring().getOutputWire().solderTo(components.branchReporterWiring().getInputWire(BranchReporter::reportBranch));
        components.model().buildHeartbeatWire(((PlatformStatusConfig)platformContext.getConfiguration().getConfigData(PlatformStatusConfig.class)).statusStateMachineHeartbeatPeriod()).solderTo(components.platformMonitorWiring().getInputWire(PlatformMonitor::heartbeat), SolderType.OFFER);
        components.eventCreatorModule().createdEventOutputWire().solderTo(components.eventIntakeModule().nonValidatedEventsInputWire(), SolderType.INJECT);
        if (callbacks.staleEventConsumer() != null) {
            OutputWire staleEvent = components.hashgraphModule().staleEventOutputWire();
            staleEvent.solderTo("staleEventCallback", "stale events", callbacks.staleEventConsumer());
        }
        OutputWire consEngineAddedEvents = components.hashgraphModule().preconsensusEventOutputWire();
        consEngineAddedEvents.solderTo(components.applicationTransactionPrehandlerWiring().getInputWire(TransactionPrehandler::prehandleApplicationTransactions));
        components.applicationTransactionPrehandlerWiring().getOutputWire().solderTo(components.stateSignatureCollectorWiring().getInputWire(StateSignatureCollector::handlePreconsensusSignatures));
        OutputWire splitReservedSignedStateWire = components.stateSignatureCollectorWiring().getOutputWire().buildSplitter("reservedStateSplitter", "reserved state lists");
        OutputWire allReservedSignedStatesWire = splitReservedSignedStateWire.buildAdvancedTransformer((AdvancedTransformation)new SignedStateReserver("allStatesReserver"));
        WireFilter saveToDiskFilter = new WireFilter(components.model(), "saveToDiskFilter", "states", state -> {
            if (state.get().isStateToSave()) {
                return true;
            }
            state.close();
            return false;
        });
        allReservedSignedStatesWire.solderTo(saveToDiskFilter.getInputWire());
        saveToDiskFilter.getOutputWire().solderTo(components.stateSnapshotManagerWiring().getInputWire(StateSnapshotManager::saveStateTask));
        OutputWire completeReservedSignedStatesWire = allReservedSignedStatesWire.buildFilter("completeStateFilter", "states", rs -> {
            if (rs.get().isComplete()) {
                return true;
            }
            rs.close();
            return false;
        }).buildAdvancedTransformer((AdvancedTransformation)new SignedStateReserver("completeStatesReserver"));
        completeReservedSignedStatesWire.solderTo(components.latestCompleteStateNexusWiring().getInputWire(LatestCompleteStateNexus::setStateIfNewer));
        PlatformWiring.solderEventWindow(components);
        components.pcesReplayerWiring().eventOutput().solderTo(components.eventIntakeModule().unhashedEventsInputWire());
        OutputWire consensusRoundOutputWire = components.hashgraphModule().consensusRoundOutputWire();
        components.pcesReplayerWiring().doneStreamingPcesOutputWire().solderTo(components.pcesModule().beginStreamingnewEventsInputWire());
        consensusRoundOutputWire.solderTo(components.transactionHandlerWiring().getInputWire(TransactionHandler::handleConsensusRound));
        consensusRoundOutputWire.solderTo(components.eventWindowManagerWiring().getInputWire(EventWindowManager::extractEventWindow));
        consensusRoundOutputWire.buildTransformer("RoundsToCesEvents", "consensus rounds", ConsensusRound::getStreamedEvents).solderTo(components.consensusEventStreamWiring().getInputWire(ConsensusEventStream::addEvents));
        consensusRoundOutputWire.solderTo(components.platformMonitorWiring().getInputWire(PlatformMonitor::consensusRound));
        OutputWire transactionHandlerSysTxnsOutputWire = components.transactionHandlerWiring().getOutputWire().buildTransformer("getSystemTransactions", "transaction handler result", TransactionHandlerResult::systemTransactions);
        transactionHandlerSysTxnsOutputWire.solderTo(components.stateSignatureCollectorWiring().getInputWire(StateSignatureCollector::handlePostconsensusSignatures));
        transactionHandlerSysTxnsOutputWire.solderTo(components.issDetectorWiring().getInputWire(IssDetector::handleStateSignatureTransactions));
        OutputWire transactionHandlerStateWithComplexityOutput = components.transactionHandlerWiring().getOutputWire().buildFilter("notNullStateFilter", "transaction handler result", thr -> thr.stateWithHashComplexity() != null).buildAdvancedTransformer((AdvancedTransformation)new StateWithHashComplexityReserver("postHandler_stateWithHashComplexityReserver"));
        transactionHandlerStateWithComplexityOutput.solderTo(components.savedStateControllerWiring().getInputWire(SavedStateController::markSavedState));
        OutputWire transactionHandlerStateOnlyOutput = transactionHandlerStateWithComplexityOutput.buildAdvancedTransformer((AdvancedTransformation)new StateWithHashComplexityToStateReserver("postHandler_stateWithHashComplexityToStateReserver"));
        transactionHandlerStateOnlyOutput.solderTo(components.latestImmutableStateNexusWiring().getInputWire(SignedStateNexus::setState));
        transactionHandlerStateOnlyOutput.solderTo(components.stateGarbageCollectorWiring().getInputWire(StateGarbageCollector::registerState));
        components.savedStateControllerWiring().getOutputWire().solderTo(components.stateHasherWiring().getInputWire(StateHasher::hashState));
        PlatformSchedulersConfig config = (PlatformSchedulersConfig)platformContext.getConfiguration().getConfigData(PlatformSchedulersConfig.class);
        components.model().buildHeartbeatWire(config.stateGarbageCollectorHeartbeatPeriod()).solderTo(components.stateGarbageCollectorWiring().getInputWire(StateGarbageCollector::heartbeat), SolderType.OFFER);
        components.model().buildHeartbeatWire(config.signedStateSentinelHeartbeatPeriod()).solderTo(components.signedStateSentinelWiring().getInputWire(SignedStateSentinel::checkSignedStates), SolderType.OFFER);
        OutputWire hashedStateOutputWire = components.stateHasherWiring().getOutputWire().buildAdvancedTransformer((AdvancedTransformation)new SignedStateReserver("postHasher_stateReserver"));
        hashedStateOutputWire.solderTo(components.hashLoggerWiring().getInputWire(HashLogger::logHashes));
        hashedStateOutputWire.solderTo(components.stateSignerWiring().getInputWire(StateSigner::signState));
        hashedStateOutputWire.solderTo(components.issDetectorWiring().getInputWire(IssDetector::handleState));
        hashedStateOutputWire.buildTransformer("postHasher_notifier", "hashed states", StateHashedNotification::from).solderTo(components.notifierWiring().getInputWire(AppNotifier::sendStateHashedNotification));
        components.stateSignerWiring().getOutputWire().solderTo("ExecutionSignatureSubmission", "state signatures", execution::submitStateSignature);
        hashedStateOutputWire.solderTo(components.stateSignatureCollectorWiring().getInputWire(StateSignatureCollector::addReservedState));
        components.stateSnapshotManagerWiring().getTransformedOutput(StateSnapshotManager::extractOldestMinimumBirthRoundOnDisk).solderTo(components.pcesModule().minimumAncientIdentifierInputWire(), SolderType.INJECT);
        components.stateSnapshotManagerWiring().getOutputWire().solderTo(components.platformMonitorWiring().getInputWire(PlatformMonitor::stateWrittenToDisk));
        components.runningEventHashOverrideWiring().runningHashUpdateOutput().solderTo(components.transactionHandlerWiring().getInputWire(TransactionHandler::updateLegacyRunningEventHash));
        components.runningEventHashOverrideWiring().runningHashUpdateOutput().solderTo(components.consensusEventStreamWiring().getInputWire(ConsensusEventStream::legacyHashOverride));
        OutputWire splitIssDetectorOutput = components.issDetectorWiring().getSplitOutput();
        splitIssDetectorOutput.solderTo(components.issHandlerWiring().getInputWire(IssHandler::issObserved));
        components.issDetectorWiring().getOutputWire().solderTo(components.platformMonitorWiring().getInputWire(PlatformMonitor::issNotification));
        completeReservedSignedStatesWire.solderTo(components.latestCompleteStateNotifierWiring().getInputWire(LatestCompleteStateNotifier::latestCompleteStateHandler));
        components.platformMonitorWiring().getOutputWire().solderTo(components.eventCreatorModule().platformStatusInputWire());
        components.platformMonitorWiring().getOutputWire().solderTo(components.hashgraphModule().platformStatusInputWire(), SolderType.INJECT);
        components.platformMonitorWiring().getOutputWire().solderTo("ExecutionStatusHandler", "status updates", execution::newPlatformStatus);
        components.platformMonitorWiring().getOutputWire().solderTo(components.gossipWiring().getPlatformStatusInput(), SolderType.INJECT);
        PlatformWiring.solderNotifier(components);
        if (callbacks.preconsensusEventConsumer() != null) {
            components.eventIntakeModule().validatedEventsOutputWire().solderTo("preConsensusEventCallback", "pre-consensus events", callbacks.preconsensusEventConsumer());
        }
        PlatformWiring.buildUnsolderedWires(components);
    }

    private static void solderEventWindow(PlatformComponents components) {
        OutputWire eventWindowOutputWire = components.eventWindowManagerWiring().getOutputWire();
        eventWindowOutputWire.solderTo(components.eventIntakeModule().eventWindowInputWire(), SolderType.INJECT);
        eventWindowOutputWire.solderTo(components.gossipWiring().getEventWindowInput(), SolderType.INJECT);
        eventWindowOutputWire.solderTo(components.pcesModule().eventWindowInputWire(), SolderType.INJECT);
        eventWindowOutputWire.solderTo(components.eventCreatorModule().eventWindowInputWire(), SolderType.INJECT);
        eventWindowOutputWire.solderTo(components.latestCompleteStateNexusWiring().getInputWire(LatestCompleteStateNexus::updateEventWindow));
        eventWindowOutputWire.solderTo(components.branchDetectorWiring().getInputWire(BranchDetector::updateEventWindow), SolderType.INJECT);
        eventWindowOutputWire.solderTo(components.branchReporterWiring().getInputWire(BranchReporter::updateEventWindow), SolderType.INJECT);
    }

    private static void solderNotifier(PlatformComponents components) {
        components.latestCompleteStateNotifierWiring().getOutputWire().solderTo(components.notifierWiring().getInputWire(AppNotifier::sendLatestCompleteStateNotification));
        components.stateSnapshotManagerWiring().getTransformedOutput(StateSnapshotManager::toNotification).solderTo(components.notifierWiring().getInputWire(AppNotifier::sendStateWrittenToDiskNotification), SolderType.INJECT);
        OutputWire issNotificationOutputWire = components.issDetectorWiring().getSplitOutput();
        issNotificationOutputWire.solderTo(components.notifierWiring().getInputWire(AppNotifier::sendIssNotification));
        components.platformMonitorWiring().getOutputWire().solderTo(components.notifierWiring().getInputWire(AppNotifier::sendPlatformStatusChangeNotification));
    }

    private static void buildUnsolderedWires(PlatformComponents components) {
        components.notifierWiring().getInputWire(AppNotifier::sendReconnectCompleteNotification);
        components.notifierWiring().getInputWire(AppNotifier::sendPlatformStatusChangeNotification);
        components.eventWindowManagerWiring().getInputWire(EventWindowManager::updateEventWindow);
        components.stateSignatureCollectorWiring().getInputWire(StateSignatureCollector::clear);
        components.issDetectorWiring().getInputWire(IssDetector::overridingState);
        components.issDetectorWiring().getInputWire(IssDetector::signalEndOfPreconsensusReplay);
        components.stateSnapshotManagerWiring().getInputWire(StateSnapshotManager::dumpStateTask);
        components.branchDetectorWiring().getInputWire(BranchDetector::clear);
        components.branchReporterWiring().getInputWire(BranchReporter::clear);
        components.platformMonitorWiring().getInputWire(PlatformMonitor::submitStatusAction);
        components.platformMonitorWiring().getInputWire(PlatformMonitor::quiescenceCommand);
    }
}

