module com.hedera.node.app {
    /* transitive */ requires com.hedera.cryptography.hints;
    /* transitive */ requires com.hedera.cryptography.wraps;
    /* transitive */ requires com.hedera.node.app.hapi.fees;
    /* transitive */ requires com.hedera.node.app.hapi.utils;
    /* transitive */ requires com.hedera.node.app.service.addressbook.impl;
    /* transitive */ requires com.hedera.node.app.service.consensus.impl;
    /* transitive */ requires com.hedera.node.app.service.contract.impl;
    /* transitive */ requires com.hedera.node.app.service.entityid;
    /* transitive */ requires com.hedera.node.app.service.file.impl;
    /* transitive */ requires com.hedera.node.app.service.network.admin.impl;
    /* transitive */ requires com.hedera.node.app.service.roster.impl;
    /* transitive */ requires com.hedera.node.app.service.schedule.impl;
    /* transitive */ requires com.hedera.node.app.service.schedule;
    /* transitive */ requires com.hedera.node.app.service.token.impl;
    /* transitive */ requires com.hedera.node.app.service.token;
    /* transitive */ requires com.hedera.node.app.service.util.impl;
    /* transitive */ requires com.hedera.node.app.spi;
    /* transitive */ requires com.hedera.node.config;
    /* transitive */ requires com.hedera.node.hapi;
    /* transitive */ requires com.hedera.pbj.runtime;
    /* transitive */ requires com.swirlds.base;
    /* transitive */ requires com.swirlds.config.api;
    /* transitive */ requires com.swirlds.metrics.api;
    /* transitive */ requires com.swirlds.platform.core;
    /* transitive */ requires com.swirlds.state.api;
    /* transitive */ requires org.hiero.base.crypto;
    /* transitive */ requires org.hiero.base.utility;
    /* transitive */ requires org.hiero.consensus.model;
    /* transitive */ requires org.hiero.consensus.utility;
    /* transitive */ requires dagger;
    /* transitive */ requires io.grpc.stub;
    /* transitive */ requires io.grpc;
    /* transitive */ requires io.helidon.grpc.core;
    /* transitive */ requires io.helidon.webclient.grpc;
    /* transitive */ requires io.helidon.webclient.http2;
    /* transitive */ requires javax.inject;
    /* transitive */ requires org.apache.logging.log4j;
    /* transitive */ requires org.hyperledger.besu.datatypes;
    /* transitive */ requires org.hyperledger.besu.evm;
    requires com.hedera.node.app.service.addressbook;
    requires com.hedera.node.app.service.consensus;
    requires com.hedera.node.app.service.contract;
    requires com.hedera.node.app.service.entityid.impl;
    requires com.hedera.node.app.service.file;
    requires com.hedera.node.app.service.network.admin;
    requires com.hedera.node.app.service.roster;
    requires com.hedera.node.app.service.util;
    requires com.hedera.pbj.grpc.client.helidon;
    requires com.swirlds.common;
    requires com.swirlds.config.extensions;
    requires com.swirlds.logging;
    requires com.swirlds.state.impl;
    requires com.swirlds.virtualmap;
    requires org.hiero.base.concurrent;
    requires org.hiero.consensus.concurrent;
    requires org.hiero.consensus.metrics;
    requires org.hiero.consensus.roster;
    requires com.github.benmanes.caffeine;
    requires com.google.common;
    requires io.grpc.netty;
    requires io.helidon.common.tls;
    requires io.helidon.webclient.api;
    requires io.netty.handler;
    requires io.netty.transport.classes.epoll;
    requires io.netty.transport;
    requires org.apache.commons.lang3;
    /* transitive */ /* static phase */ requires com.github.spotbugs.annotations;
    /* static phase */ requires java.compiler;

    exports com.hedera.node.app;
    exports com.hedera.node.app.state;
    exports com.hedera.node.app.quiescence;
    exports com.hedera.node.app.workflows.ingest;
    exports com.hedera.node.app.workflows.query;
    exports com.hedera.node.app.workflows;
    exports com.hedera.node.app.state.merkle to com.hedera.node.app.test.fixtures, com.hedera.node.test.clients, com.hedera.state.validator;
    exports com.hedera.node.app.workflows.dispatcher;
    exports com.hedera.node.app.workflows.standalone;
    exports com.hedera.node.app.config;
    exports com.hedera.node.app.workflows.handle.validation;
    exports com.hedera.node.app.signature;
    exports com.hedera.node.app.info;
    exports com.hedera.node.app.grpc;
    exports com.hedera.node.app.hints;
    exports com.hedera.node.app.hints.handlers;
    exports com.hedera.node.app.hints.impl;
    exports com.hedera.node.app.history;
    exports com.hedera.node.app.history.handlers;
    exports com.hedera.node.app.history.impl;
    exports com.hedera.node.app.metrics;
    exports com.hedera.node.app.authorization;
    exports com.hedera.node.app.platform;
    exports com.hedera.node.app.components;
    exports com.hedera.node.app.workflows.handle;
    exports com.hedera.node.app.workflows.prehandle;
    exports com.hedera.node.app.validation;
    exports com.hedera.node.app.state.listeners;
    exports com.hedera.node.app.services;
    exports com.hedera.node.app.store;
    exports com.hedera.node.app.workflows.handle.steps;
    exports com.hedera.node.app.workflows.handle.record;
    exports com.hedera.node.app.workflows.handle.throttle;
    exports com.hedera.node.app.workflows.handle.dispatch;
    exports com.hedera.node.app.workflows.handle.cache;
    exports com.hedera.node.app.state.recordcache;
    exports com.hedera.node.app.records;
    exports com.hedera.node.app.blocks;
    exports com.hedera.node.app.fees;
    exports com.hedera.node.app.throttle;
    exports com.hedera.node.app.blocks.impl;
    exports com.hedera.node.app.blocks.impl.streaming;
    exports com.hedera.node.app.workflows.handle.metric;
    exports com.hedera.node.app.tss;
    exports com.hedera.node.app.workflows.handle.stack;
    exports com.hedera.node.app.fees.congestion;
    exports com.hedera.node.app.throttle.annotations;
    exports com.hedera.node.app.workflows.query.annotations;
    exports com.hedera.node.app.signature.impl;
    exports com.hedera.node.app.workflows.standalone.impl;
    exports com.hedera.node.app.records.impl;
    exports com.hedera.node.app.records.impl.producers;
    exports com.hedera.node.app.records.impl.producers.formats;
    exports com.hedera.node.app.grpc.impl.netty;
    exports com.hedera.node.app.tss.schemas;
    exports com.hedera.node.app.blocks.schemas;
    exports com.hedera.node.app.records.schemas;
    exports com.hedera.node.app.hints.schemas;
    exports com.hedera.node.app.blocks.impl.streaming.config;
    exports com.hedera.node.app.history.schemas;

    provides ConfigurationExtension with ServicesConfigExtension;

}

