/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.crypto.internal;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import org.hiero.base.crypto.BytesSigner;
import org.hiero.base.crypto.CryptographyException;

public class JcaSigner
implements BytesSigner {
    private final Signature signature;

    public JcaSigner(@NonNull PrivateKey privateKey, @NonNull String algorithm, @NonNull String provider) {
        try {
            this.signature = Signature.getInstance(algorithm, provider);
            this.signature.initSign(privateKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new CryptographyException((Throwable)e);
        }
    }

    @NonNull
    public Bytes sign(@NonNull Bytes data) {
        try {
            data.updateSignature(this.signature);
            return Bytes.wrap((byte[])this.signature.sign());
        }
        catch (SignatureException e) {
            throw new CryptographyException((Throwable)e);
        }
    }
}

