/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.intake.impl.deduplication;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.metrics.api.LongAccumulator;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.hiero.consensus.event.IntakeEventCounter;
import org.hiero.consensus.event.intake.impl.deduplication.EventDeduplicator;
import org.hiero.consensus.metrics.RunningAverageMetric;
import org.hiero.consensus.metrics.extensions.CountPerSecond;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.sequence.map.SequenceMap;
import org.hiero.consensus.model.sequence.map.StandardSequenceMap;

public class StandardEventDeduplicator
implements EventDeduplicator {
    private static final Function<EventDescriptorWrapper, Set<Bytes>> NEW_HASH_SET = ignored -> new HashSet();
    private static final int INITIAL_CAPACITY = 1024;
    private EventWindow eventWindow;
    private final IntakeEventCounter intakeEventCounter;
    private final SequenceMap<EventDescriptorWrapper, Set<Bytes>> observedEvents;
    private static final LongAccumulator.Config DISPARATE_SIGNATURE_CONFIG = new LongAccumulator.Config("platform", "eventsWithDisparateSignature").withDescription("Events received that match a descriptor of a previous event, but with a different signature").withUnit("events");
    private final LongAccumulator disparateSignatureAccumulator;
    private final CountPerSecond duplicateEventsPerSecond;
    private static final RunningAverageMetric.Config AVG_DUPLICATE_PERCENT_CONFIG = new RunningAverageMetric.Config("platform", "dupEvPercent").withDescription("percentage of events received that are already known").withFormat("%,10.2f");
    private final RunningAverageMetric avgDuplicatePercent;

    public StandardEventDeduplicator(@NonNull Metrics metrics, @NonNull IntakeEventCounter intakeEventCounter) {
        this.intakeEventCounter = Objects.requireNonNull(intakeEventCounter);
        this.disparateSignatureAccumulator = (LongAccumulator)metrics.getOrCreate((MetricConfig)DISPARATE_SIGNATURE_CONFIG);
        this.duplicateEventsPerSecond = new CountPerSecond(metrics, new CountPerSecond.Config("platform", "dupEv_per_sec").withDescription("number of events received per second that are already known").withUnit("hz"));
        this.avgDuplicatePercent = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_DUPLICATE_PERCENT_CONFIG);
        this.eventWindow = EventWindow.getGenesisEventWindow();
        this.observedEvents = new StandardSequenceMap(0L, 1024, true, EventDescriptorWrapper::birthRound);
    }

    @Override
    @Nullable
    public PlatformEvent handleEvent(@NonNull PlatformEvent event) {
        if (this.eventWindow.isAncient(event)) {
            this.intakeEventCounter.eventExitedIntakePipeline(event.getSenderId());
            return null;
        }
        Set signatures = (Set)this.observedEvents.computeIfAbsent((Object)event.getDescriptor(), NEW_HASH_SET);
        if (signatures.add(event.getSignature())) {
            if (signatures.size() != 1) {
                this.disparateSignatureAccumulator.update(1L);
            }
            this.avgDuplicatePercent.update(0.0);
            return event;
        }
        this.duplicateEventsPerSecond.count(1);
        this.avgDuplicatePercent.update(100.0);
        this.intakeEventCounter.eventExitedIntakePipeline(event.getSenderId());
        return null;
    }

    @Override
    public void setEventWindow(@NonNull EventWindow eventWindow) {
        this.eventWindow = Objects.requireNonNull(eventWindow);
        this.observedEvents.shiftWindow(eventWindow.ancientThreshold());
    }

    @Override
    public void clear() {
        this.observedEvents.clear();
    }
}

