/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.builder.api.Option;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;

public interface Annotated {
    @Option.Singular
    public List<Annotation> annotations();

    @Option.Singular
    public List<Annotation> inheritedAnnotations();

    default public List<Annotation> allAnnotations() {
        ArrayList<Annotation> result = new ArrayList<Annotation>(this.annotations());
        result.addAll(this.inheritedAnnotations());
        return List.copyOf(result);
    }

    default public Optional<Annotation> findAnnotation(TypeName annotationType) {
        for (Annotation annotation : this.annotations()) {
            if (!annotation.typeName().equals(annotationType)) continue;
            return Optional.of(annotation);
        }
        return Optional.empty();
    }

    default public Annotation annotation(TypeName annotationType) {
        return this.findAnnotation(annotationType).orElseThrow(() -> new NoSuchElementException("Annotation " + String.valueOf(annotationType) + " is not present. Guard with hasAnnotation(), or use findAnnotation() instead"));
    }

    default public boolean hasAnnotation(TypeName annotationType) {
        return this.annotations().stream().anyMatch(it -> annotationType.equals(it.typeName()));
    }
}

