/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.QualifiedUid;
import org.identityconnectors.framework.common.serializer.SerializerUtil;

public final class OperationOptionsBuilder {
    private final Map<String, Object> _options;

    public OperationOptionsBuilder() {
        this._options = new HashMap<String, Object>();
    }

    public OperationOptionsBuilder(OperationOptions options) {
        Map operationOptionsClone;
        Assertions.nullCheck(options, "options");
        this._options = operationOptionsClone = (Map)SerializerUtil.cloneObject(options.getOptions());
    }

    public OperationOptionsBuilder setOption(String name, Object value) {
        Assertions.blankCheck(name, "name");
        this._options.put(name, value);
        return this;
    }

    public OperationOptionsBuilder setAttributesToGet(String ... attrNames) {
        Assertions.nullCheck(attrNames, "attrNames");
        this._options.put("ATTRS_TO_GET", attrNames);
        return this;
    }

    public OperationOptionsBuilder setAttributesToGet(Collection<String> attrNames) {
        Assertions.nullCheck(attrNames, "attrNames");
        String[] attrs = new String[attrNames.size()];
        attrs = attrNames.toArray(attrs);
        this._options.put("ATTRS_TO_GET", attrs);
        return this;
    }

    public OperationOptionsBuilder setRunWithPassword(GuardedString password) {
        Assertions.nullCheck(password, "password");
        this._options.put("RUN_WITH_PASSWORD", password);
        return this;
    }

    public OperationOptionsBuilder setRunAsUser(String user) {
        Assertions.nullCheck(user, "user");
        this._options.put("RUN_AS_USER", user);
        return this;
    }

    public OperationOptionsBuilder setScope(String scope) {
        Assertions.nullCheck(scope, "scope");
        this._options.put("SCOPE", scope);
        return this;
    }

    public OperationOptionsBuilder setContainer(QualifiedUid container) {
        Assertions.nullCheck(container, "container");
        this._options.put("CONTAINER", container);
        return this;
    }

    public Map<String, Object> getOptions() {
        return this._options;
    }

    public OperationOptions build() {
        return new OperationOptions(this._options);
    }
}

