/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl;

import com.hedera.node.app.blocks.BlockStreamManager;
import com.hedera.node.app.blocks.StreamingTreeHasher;
import com.hedera.node.app.blocks.impl.BlockImplUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class NaiveStreamingTreeHasher
implements StreamingTreeHasher {
    private static final Bytes EMPTY_HASH_BYTES = BlockImplUtils.hashLeaf(BlockStreamManager.ZERO_BLOCK_HASH);
    private static final byte[] EMPTY_HASH = EMPTY_HASH_BYTES.toByteArray();
    private final List<byte[]> leafHashes = new ArrayList<byte[]>();
    private boolean rootHashRequested = false;

    public static Bytes computeRootHash(@NonNull List<byte[]> leafHashes) {
        NaiveStreamingTreeHasher hasher = new NaiveStreamingTreeHasher();
        for (byte[] hash : leafHashes) {
            hasher.addLeaf(ByteBuffer.wrap(hash));
        }
        return hasher.rootHash().join();
    }

    @Override
    public void addLeaf(@NonNull ByteBuffer hash) {
        if (this.rootHashRequested) {
            throw new IllegalStateException("Root hash already requested");
        }
        if (hash.remaining() < HASH_LENGTH) {
            throw new IllegalArgumentException("Buffer has less than " + HASH_LENGTH + " bytes remaining");
        }
        byte[] bytes = new byte[HASH_LENGTH];
        hash.get(bytes);
        this.leafHashes.add(bytes);
    }

    @Override
    public CompletableFuture<Bytes> rootHash() {
        this.rootHashRequested = true;
        if (this.leafHashes.isEmpty()) {
            return CompletableFuture.completedFuture(EMPTY_HASH_BYTES);
        }
        LinkedList<Object> hashes = new LinkedList<byte[]>(this.leafHashes);
        int n = hashes.size();
        if ((n & n - 1) != 0) {
            int paddedN = Integer.highestOneBit(n) << 1;
            while (hashes.size() < paddedN) {
                hashes.add(EMPTY_HASH);
            }
        }
        while (hashes.size() > 1) {
            LinkedList<byte[]> newLeafHashes = new LinkedList<byte[]>();
            while (!hashes.isEmpty()) {
                byte[] left = (byte[])hashes.poll();
                byte[] right = (byte[])hashes.poll();
                byte[] hashed = BlockImplUtils.hashInternalNode(left, Objects.requireNonNull(right));
                newLeafHashes.add(hashed);
            }
            hashes = newLeafHashes;
        }
        return CompletableFuture.completedFuture(Bytes.wrap((byte[])Objects.requireNonNull((byte[])hashes.poll())));
    }
}

