/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history.impl;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.history.ConstructionNodeId;
import com.hedera.hapi.node.state.history.HistoryProofConstruction;
import com.hedera.hapi.node.state.history.HistoryProofVote;
import com.hedera.hapi.node.state.history.ProofKeySet;
import com.hedera.hapi.node.state.history.WrapsMessageHistory;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.platform.state.NodeId;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.history.ReadableHistoryStore;
import com.hedera.node.app.history.schemas.V059HistorySchema;
import com.hedera.node.app.history.schemas.V069HistorySchema;
import com.hedera.node.app.service.roster.impl.ActiveRosters;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ReadableHistoryStoreImpl
implements ReadableHistoryStore {
    private final ReadableSingletonState<ProtoBytes> ledgerId;
    private final ReadableSingletonState<HistoryProofConstruction> nextConstruction;
    private final ReadableSingletonState<HistoryProofConstruction> activeConstruction;
    private final ReadableKVState<NodeId, ProofKeySet> proofKeySets;
    private final ReadableKVState<ConstructionNodeId, HistoryProofVote> votes;
    private final ReadableKVState<ConstructionNodeId, WrapsMessageHistory> wrapsMessageHistories;

    public ReadableHistoryStoreImpl(@NonNull ReadableStates states) {
        Objects.requireNonNull(states);
        this.ledgerId = states.getSingleton(V059HistorySchema.LEDGER_ID_STATE_ID);
        this.nextConstruction = states.getSingleton(V059HistorySchema.NEXT_PROOF_CONSTRUCTION_STATE_ID);
        this.activeConstruction = states.getSingleton(V059HistorySchema.ACTIVE_PROOF_CONSTRUCTION_STATE_ID);
        this.proofKeySets = states.get(V059HistorySchema.PROOF_KEY_SETS_STATE_ID);
        this.votes = states.get(V059HistorySchema.PROOF_VOTES_STATE_ID);
        this.wrapsMessageHistories = states.get(V069HistorySchema.WRAPS_MESSAGE_HISTORIES_STATE_ID);
    }

    @Override
    @Nullable
    public Bytes getLedgerId() {
        Bytes maybeLedgerId = Objects.requireNonNull((ProtoBytes)this.ledgerId.get()).value();
        return Bytes.EMPTY.equals((Object)maybeLedgerId) ? null : maybeLedgerId;
    }

    @Override
    @NonNull
    public HistoryProofConstruction getActiveConstruction() {
        return Objects.requireNonNull((HistoryProofConstruction)this.activeConstruction.get());
    }

    @Override
    @NonNull
    public HistoryProofConstruction getNextConstruction() {
        return Objects.requireNonNull((HistoryProofConstruction)this.nextConstruction.get());
    }

    @Override
    @NonNull
    public HistoryProofConstruction getConstructionOrThrow(long constructionId) {
        if (Objects.requireNonNull((HistoryProofConstruction)this.activeConstruction.get()).constructionId() == constructionId) {
            return Objects.requireNonNull((HistoryProofConstruction)this.activeConstruction.get());
        }
        if (Objects.requireNonNull((HistoryProofConstruction)this.nextConstruction.get()).constructionId() == constructionId) {
            return Objects.requireNonNull((HistoryProofConstruction)this.nextConstruction.get());
        }
        throw new IllegalArgumentException("No construction with id " + constructionId);
    }

    @Override
    @Nullable
    public HistoryProofConstruction getConstructionFor(@NonNull ActiveRosters activeRosters) {
        Objects.requireNonNull(activeRosters);
        return switch (activeRosters.phase()) {
            default -> throw new MatchException(null, null);
            case ActiveRosters.Phase.BOOTSTRAP, ActiveRosters.Phase.TRANSITION -> {
                HistoryProofConstruction construction = Objects.requireNonNull((HistoryProofConstruction)this.nextConstruction.get());
                if (this.constructionIsFor(construction, activeRosters)) {
                    yield construction;
                }
                construction = Objects.requireNonNull((HistoryProofConstruction)this.activeConstruction.get());
                if (this.constructionIsFor(construction, activeRosters)) {
                    yield construction;
                }
                yield null;
            }
            case ActiveRosters.Phase.HANDOFF -> null;
        };
    }

    @Override
    @NonNull
    public Map<Long, HistoryProofVote> getVotes(long constructionId, @NonNull Set<Long> nodeIds) {
        Objects.requireNonNull(nodeIds);
        HashMap<Long, HistoryProofVote> constructionVotes = new HashMap<Long, HistoryProofVote>();
        for (Long nodeId : nodeIds) {
            HistoryProofVote vote = (HistoryProofVote)this.votes.get((Object)new ConstructionNodeId(constructionId, nodeId.longValue()));
            if (vote == null) continue;
            constructionVotes.put(nodeId, vote);
        }
        return constructionVotes;
    }

    @Override
    @NonNull
    public List<ReadableHistoryStore.ProofKeyPublication> getProofKeyPublications(@NonNull Set<Long> nodeIds) {
        Objects.requireNonNull(nodeIds);
        ArrayList<ReadableHistoryStore.ProofKeyPublication> publications = new ArrayList<ReadableHistoryStore.ProofKeyPublication>();
        nodeIds.forEach(id -> {
            ProofKeySet keySet = (ProofKeySet)this.proofKeySets.get((Object)new NodeId(id.longValue()));
            if (keySet != null) {
                publications.add(new ReadableHistoryStore.ProofKeyPublication((long)id, keySet.key(), HapiUtils.asInstant((Timestamp)keySet.adoptionTimeOrThrow())));
            }
        });
        return publications;
    }

    @Override
    @NonNull
    public List<ReadableHistoryStore.WrapsMessagePublication> getWrapsMessagePublications(long constructionId, @NonNull Set<Long> nodeIds) {
        Objects.requireNonNull(nodeIds);
        ArrayList<ReadableHistoryStore.WrapsMessagePublication> publications = new ArrayList<ReadableHistoryStore.WrapsMessagePublication>();
        for (Long nodeId : nodeIds) {
            WrapsMessageHistory history = (WrapsMessageHistory)this.wrapsMessageHistories.get((Object)new ConstructionNodeId(constructionId, nodeId.longValue()));
            if (history == null) continue;
            publications.addAll(ReadableHistoryStore.WrapsMessagePublication.allFromHistory(nodeId, history));
        }
        return publications;
    }

    private boolean constructionIsFor(@NonNull HistoryProofConstruction construction, @NonNull ActiveRosters activeRosters) {
        return activeRosters.sourceRosterHash().equals((Object)construction.sourceRosterHash()) && activeRosters.targetRosterHash().equals((Object)construction.targetRosterHash());
    }
}

